/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.serviceconfig.config;

import io.datarouter.instrumentation.serviceconfig.ServiceConfigurationDto;
import io.datarouter.instrumentation.serviceconfig.ServiceConfigurationPublisher;
import io.datarouter.serviceconfig.config.DatarouterServiceConfigurationSettings;
import io.datarouter.storage.config.DatarouterSubscribersSupplier;
import io.datarouter.storage.config.properties.AdminEmail;
import io.datarouter.web.config.ServletContextSupplier;
import io.datarouter.web.config.service.DomainFinder;
import io.datarouter.web.config.service.ServiceName;
import io.datarouter.web.listener.DatarouterAppListener;
import io.datarouter.web.service.DocumentationNamesAndLinksSupplier;
import io.datarouter.web.service.ServiceDescriptionSupplier;
import java.util.HashSet;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterServiceConfigurationAppListener
implements DatarouterAppListener {
    @Inject
    private DatarouterServiceConfigurationSettings settings;
    @Inject
    private ServiceConfigurationPublisher serviceConfigurationPublisher;
    @Inject
    private DatarouterSubscribersSupplier subscribers;
    @Inject
    private ServiceName serviceName;
    @Inject
    private ServletContextSupplier servletContext;
    @Inject
    private DomainFinder domainFinder;
    @Inject
    private ServiceDescriptionSupplier serviceDescriptionSupplier;
    @Inject
    private DocumentationNamesAndLinksSupplier documentationNamesAndLinksSupplier;
    @Inject
    private AdminEmail adminEmail;

    public void onStartUp() {
        if (!((Boolean)this.settings.publishServiceConfig.get()).booleanValue()) {
            return;
        }
        HashSet admins = new HashSet();
        Optional.ofNullable(this.adminEmail.get()).ifPresent(admins::add);
        admins.addAll(this.subscribers.get());
        ServiceConfigurationDto dto = new ServiceConfigurationDto(this.serviceName.get(), admins, this.subscribers.get(), this.serviceDescriptionSupplier.get(), this.domainFinder.getDomainPreferPublic(), this.servletContext.getContextName(), this.documentationNamesAndLinksSupplier.getReadmeDocs());
        try {
            this.serviceConfigurationPublisher.add(dto);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

