/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.serviceconfig.config;

import io.datarouter.httpclient.client.DatarouterService;
import io.datarouter.instrumentation.serviceconfig.ServiceConfigurationDto;
import io.datarouter.instrumentation.serviceconfig.ServiceConfigurationPublisher;
import io.datarouter.serviceconfig.config.DatarouterServiceConfigurationSettings;
import io.datarouter.storage.config.DatarouterAdditionalAdministratorsSupplier;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.web.listener.DatarouterAppListener;
import io.datarouter.web.service.DocumentationNamesAndLinksSupplier;
import io.datarouter.web.service.ServiceDescriptionSupplier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterServiceConfigurationAppListener
implements DatarouterAppListener {
    @Inject
    private DatarouterServiceConfigurationSettings settings;
    @Inject
    private ServiceConfigurationPublisher serviceConfigurationPublisher;
    @Inject
    private DatarouterAdditionalAdministratorsSupplier additionalAdministrators;
    @Inject
    private DatarouterProperties datarouterProperties;
    @Inject
    private DatarouterService datarouterService;
    @Inject
    private ServiceDescriptionSupplier serviceDescriptionSupplier;
    @Inject
    private DocumentationNamesAndLinksSupplier documentationNamesAndLinksSupplier;

    public void onStartUp() {
        if (!((Boolean)this.settings.publishServiceConfig.get()).booleanValue()) {
            return;
        }
        HashSet admins = new HashSet();
        Optional.ofNullable(this.datarouterProperties.getAdministratorEmail()).ifPresent(admins::add);
        admins.addAll((Collection)this.additionalAdministrators.get());
        ServiceConfigurationDto dto = new ServiceConfigurationDto(this.datarouterService.getServiceName(), admins, (String)this.serviceDescriptionSupplier.get(), this.datarouterService.getDomainPreferPublic(), this.datarouterService.getContextName(), this.documentationNamesAndLinksSupplier.getReadmeDocs());
        try {
            this.serviceConfigurationPublisher.add(dto);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

