/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.snapshotmanager;

import io.datarouter.filesystem.snapshot.benchmark.SnapshotBenchmark;
import io.datarouter.filesystem.snapshot.group.SnapshotGroup;
import io.datarouter.filesystem.snapshot.group.SnapshotGroups;
import io.datarouter.util.Require;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.handler.types.optional.OptionalBoolean;
import io.datarouter.web.handler.types.optional.OptionalString;
import io.datarouter.web.html.form.HtmlForm;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4FormHtml;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.FormTag;
import javax.inject.Inject;

public class DatarouterSnapshotBenchmarkHandler
extends BaseHandler {
    private static final String P_group = "group";
    private static final String P_numEntries = "numEntries";
    private static final String P_persist = "persist";
    private static final String P_delete = "delete";
    private static final String P_submitAction = "submitAction";
    private static final long DEFAULT_NUM_ENTRIES = 10000000L;
    private static final boolean DEFAULT_PERSIST = true;
    private static final boolean DEFAULT_DELETE = true;
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private SnapshotGroups groups;

    @BaseHandler.Handler(defaultHandler=true)
    public Mav defaultHandler(@Param(value="group") OptionalString optGroup, @Param(value="numEntries") OptionalString optNumEntries, @Param(value="persist") OptionalBoolean optPersist, @Param(value="delete") OptionalBoolean optDelete, @Param(value="submitAction") OptionalString submitAction) {
        SnapshotGroup group = null;
        String errorGroup = null;
        if (optGroup.isPresent()) {
            try {
                group = (SnapshotGroup)Require.notNull((Object)this.groups.getGroup((String)optGroup.get()));
            }
            catch (Exception e) {
                errorGroup = "Group not found";
            }
        }
        long numEntries = 10000000L;
        String errorNumEntries = null;
        try {
            numEntries = optNumEntries.map(Long::valueOf).orElse(numEntries);
        }
        catch (Exception e) {
            errorNumEntries = "Must be an integer (long) number";
        }
        boolean persist = true;
        String errorPersist = null;
        try {
            persist = optPersist.map(Boolean::valueOf).orElse(persist);
        }
        catch (Exception e) {
            errorPersist = "Must be \"true\" or \"false\"";
        }
        boolean delete = true;
        String errorDelete = null;
        try {
            delete = optDelete.map(Boolean::valueOf).orElse(delete);
        }
        catch (Exception e) {
            errorDelete = "Must be \"true\" or \"false\"";
        }
        HtmlForm form = new HtmlForm().withMethod("post");
        form.addTextField().withDisplay("Group").withError(errorGroup).withName(P_group).withPlaceholder(P_group).withValue((String)optGroup.orElse(null));
        form.addTextField().withDisplay("Num Entries").withError(errorNumEntries).withName(P_numEntries).withPlaceholder(P_numEntries).withValue(String.valueOf(numEntries));
        form.addTextField().withDisplay("Persist").withError(errorPersist).withName(P_persist).withPlaceholder("true").withValue(String.valueOf(persist));
        form.addTextField().withDisplay("Delete").withError(errorDelete).withName(P_delete).withPlaceholder("true").withValue(String.valueOf(persist));
        form.addButton().withDisplay("Run").withValue("anything");
        if (submitAction.isEmpty() || form.hasErrors()) {
            return this.pageFactory.startBuilder(this.request).withTitle("Datarouter Filesystem - Benchmark").withContent((DomContent)Html.makeContent(form)).buildMav();
        }
        int numInputThreads = Runtime.getRuntime().availableProcessors();
        int numWriterThreads = Runtime.getRuntime().availableProcessors();
        SnapshotBenchmark benchmark = new SnapshotBenchmark(group, numInputThreads, numWriterThreads, numEntries, 10000, persist);
        benchmark.execute();
        if (persist && delete) {
            benchmark.cleanup();
        }
        benchmark.shutdown();
        return this.pageFactory.message(this.request, "Complete.  See logs for output");
    }

    private static class Html {
        private Html() {
        }

        public static DivTag makeContent(HtmlForm htmlForm) {
            FormTag form = (FormTag)Bootstrap4FormHtml.render((HtmlForm)htmlForm).withClass("card card-body bg-light");
            return (DivTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h2((String)"Snapshot - Benchmark"), form, TagCreator.br()}).withClass("container mt-3");
        }
    }
}

