/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.snapshotmanager;

import io.datarouter.filesystem.snapshot.group.SnapshotGroup;
import io.datarouter.filesystem.snapshot.group.SnapshotGroups;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.filesystem.snapshot.reader.SnapshotIdReader;
import io.datarouter.filesystem.snapshot.reader.block.BlockLoader;
import io.datarouter.filesystem.snapshot.reader.record.SnapshotRecord;
import io.datarouter.filesystem.snapshot.web.SnapshotRecordStringDecoder;
import io.datarouter.filesystem.snapshot.web.SnapshotRecordStrings;
import io.datarouter.util.lang.ReflectionTool;
import io.datarouter.util.tuple.Twin;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.html.j2html.J2HtmlTable;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import io.datarouter.web.requirejs.DatarouterWebRequireJsV2;
import j2html.tags.DomContent;
import j2html.tags.specialized.TableTag;
import java.util.ArrayList;
import java.util.stream.IntStream;
import javax.inject.Inject;

public class DatarouterSnapshotEntryHandler
extends BaseHandler {
    public static final String P_groupId = "groupId";
    public static final String P_snapshotId = "snapshotId";
    public static final String P_id = "id";
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private SnapshotGroups groups;

    @BaseHandler.Handler
    public Mav entry(@Param(value="groupId") String groupId, @Param(value="snapshotId") String snapshotId, @Param(value="id") Long id) {
        SnapshotKey snapshotKey = new SnapshotKey(groupId, snapshotId);
        return this.pageFactory.startBuilder(this.request).withTitle("Datarouter Filesystem - Snapshot Entry").withRequires(new String[]{DatarouterWebRequireJsV2.SORTTABLE}).withContent((DomContent)this.buildTable(snapshotKey, id)).buildMav();
    }

    private TableTag buildTable(SnapshotKey snapshotKey, long id) {
        SnapshotGroup group = this.groups.getGroup(snapshotKey.groupId);
        SnapshotIdReader reader = new SnapshotIdReader(snapshotKey, (BlockLoader)this.groups);
        SnapshotRecord record = reader.getRecord(id);
        SnapshotRecordStringDecoder decoder = (SnapshotRecordStringDecoder)ReflectionTool.create((Class)group.getSnapshotEntryDecoderClass());
        SnapshotRecordStrings decoded = decoder.decode(record);
        ArrayList<Twin> rows = new ArrayList<Twin>();
        rows.add(new Twin((Object)P_id, (Object)Long.toString(record.id)));
        rows.add(new Twin((Object)decoder.keyName(), (Object)decoded.key));
        rows.add(new Twin((Object)decoder.valueName(), (Object)decoded.value));
        IntStream.range(0, decoded.columnValues.size()).mapToObj(column -> new Twin((Object)decoder.columnValueName(column), (Object)((String)snapshotRecordStrings.columnValues.get(column)))).forEach(rows::add);
        TableTag table = new J2HtmlTable().withClasses(new String[]{"sortable table table-sm table-striped my-4 border"}).withColumn("field", twin -> twin.getLeft()).withColumn("value", twin -> twin.getRight()).build(rows);
        return table;
    }
}

