/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.snapshotmanager;

import io.datarouter.filesystem.snapshot.group.SnapshotGroup;
import io.datarouter.filesystem.snapshot.group.dto.SnapshotKeyAndNumRecords;
import io.datarouter.filesystem.snapshot.group.dto.SnapshotWriteResult;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.filesystem.snapshot.reader.ScanningSnapshotReader;
import io.datarouter.filesystem.snapshot.reader.block.BlockLoader;
import io.datarouter.filesystem.snapshot.reader.record.SnapshotLeafRecord;
import io.datarouter.filesystem.snapshot.writer.SnapshotWriterConfig;
import io.datarouter.scanner.Scanner;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotMerger {
    private static final Logger logger = LoggerFactory.getLogger(SnapshotMerger.class);
    private final Supplier<Boolean> shouldStop;
    private final SnapshotGroup mergeGroup;
    private final SnapshotGroup destinationGroup;
    private final ExecutorService readExec;
    private final ExecutorService writeExec;
    private final SnapshotWriterConfig writerConfig;
    private final int scanNumBlocks;
    private final int mergeFactor;

    public SnapshotMerger(Supplier<Boolean> shouldStop, SnapshotGroup mergeGroup, SnapshotGroup destinationGroup, ExecutorService readExec, ExecutorService writeExec, SnapshotWriterConfig writerConfig, int scanNumBlocks, int mergeFactor) {
        this.shouldStop = shouldStop;
        this.mergeGroup = mergeGroup;
        this.destinationGroup = destinationGroup;
        this.readExec = readExec;
        this.writeExec = writeExec;
        this.writerConfig = writerConfig;
        this.scanNumBlocks = scanNumBlocks;
        this.mergeFactor = mergeFactor;
    }

    public void merge() {
        Map summaryByKey = this.mergeGroup.keyReadOps(false).scanSnapshotKeysAndRootBlocks(this.readExec, 10).map(SnapshotKeyAndNumRecords::new).toMap(summary -> summary.key);
        while (summaryByKey.size() > 1) {
            SnapshotGroup outputGroup = summaryByKey.size() <= this.mergeFactor ? this.destinationGroup : this.mergeGroup;
            Scanner.of(summaryByKey.values()).minN(SnapshotKeyAndNumRecords.BY_NUM_RECORDS, this.mergeFactor).map(summary -> summary.key).flush(keys -> {
                SnapshotWriteResult result = this.combineSnapshots((List<SnapshotKey>)keys, outputGroup);
                SnapshotKeyAndNumRecords newSummary = new SnapshotKeyAndNumRecords(result.toSnapshotKeyAndRoot());
                summaryByKey.put(result.key, newSummary);
            }).forEach(summaryByKey::remove);
        }
    }

    private SnapshotWriteResult combineSnapshots(List<SnapshotKey> keys, SnapshotGroup outputGroup) {
        SnapshotWriteResult result = (SnapshotWriteResult)Scanner.of(keys).map(key -> new ScanningSnapshotReader(key, this.readExec, 10, (BlockLoader)this.mergeGroup, this.scanNumBlocks)).collate(reader -> reader.scanLeafRecords(0L), SnapshotLeafRecord.KEY_COMPARATOR).deduplicateConsecutiveBy(leafRecord -> leafRecord.key, Arrays::equals).map(SnapshotLeafRecord::entry).batch(10000).apply(batches -> outputGroup.writeOps().write(this.writerConfig, batches, this.writeExec, this.shouldStop));
        keys.forEach(key -> this.mergeGroup.deleteOps().deleteSnapshot(key, this.writeExec, 10));
        logger.warn("combined {}, {}", (Object)keys.size(), keys);
        return result;
    }
}

