/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.callsite;

import io.datarouter.storage.callsite.CallsiteRecord;
import io.datarouter.storage.callsite.CallsiteStat;
import io.datarouter.storage.callsite.CallsiteStatComparator;
import io.datarouter.storage.callsite.CallsiteStatKey;
import io.datarouter.storage.callsite.CallsiteStatReportMetadata;
import io.datarouter.util.ComparableTool;
import io.datarouter.util.io.ReaderTool;
import io.datarouter.util.number.NumberFormatter;
import io.datarouter.util.string.StringTool;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallsiteAnalyzer
implements Callable<String> {
    private static final Logger logger = LoggerFactory.getLogger(CallsiteAnalyzer.class);
    private final String logPath;
    private final Integer maxResults;
    private final CallsiteStatComparator comparatorEnum;
    private Map<CallsiteStatKey, CallsiteStat> aggregateStatByKey = new HashMap<CallsiteStatKey, CallsiteStat>();

    public CallsiteAnalyzer(String logPath, Integer maxResults, CallsiteStatComparator comparatorEnum) {
        this.logPath = logPath;
        this.maxResults = maxResults;
        this.comparatorEnum = comparatorEnum;
    }

    @Override
    public String call() {
        int numLines = 0;
        Date firstDate = new Date(Long.MAX_VALUE);
        Date lastDate = new Date(0L);
        for (String line : ReaderTool.scanFileLines((String)this.logPath).iterable()) {
            CallsiteStat stat;
            ++numLines;
            CallsiteRecord record = CallsiteRecord.fromLogLine(line);
            if (ComparableTool.lt((Comparable)record.getTimestamp(), (Comparable)firstDate)) {
                firstDate = record.getTimestamp();
            }
            if (ComparableTool.gt((Comparable)record.getTimestamp(), (Comparable)lastDate)) {
                lastDate = record.getTimestamp();
            }
            if (!this.aggregateStatByKey.containsKey((stat = new CallsiteStat(record.getCallsite(), record.getNodeName(), record.getDatarouterMethodName(), 1L, record.getDurationNs(), record.getNumItems())).getKey())) {
                this.aggregateStatByKey.put(stat.getKey(), stat);
            }
            this.aggregateStatByKey.get(stat.getKey()).addMetrics(stat);
            if (numLines % 100000 != 0) continue;
            logger.warn("scanned " + NumberFormatter.addCommas((Number)numLines) + " in " + this.logPath);
        }
        ArrayList<CallsiteStat> stats = new ArrayList<CallsiteStat>(this.aggregateStatByKey.values());
        Collections.sort(stats, Collections.reverseOrder(this.comparatorEnum.getComparator()));
        CallsiteStatReportMetadata reportMetadata = CallsiteStatReportMetadata.inspect(stats);
        StringBuilder sb = new StringBuilder();
        int numDaoCallsites = CallsiteStat.countDaoCallsites(stats);
        long numSeconds = (lastDate.getTime() - firstDate.getTime()) / 1000L;
        double callsPerSec = (double)numLines / (double)numSeconds;
        sb.append("          path: " + this.logPath + "\n");
        sb.append(" file size (B): " + NumberFormatter.addCommas((Number)new File(this.logPath).length()) + "\n");
        sb.append("         lines: " + NumberFormatter.addCommas((Number)numLines) + "\n");
        sb.append("     callsites: " + NumberFormatter.addCommas((Number)stats.size()) + "\n");
        sb.append(" dao callsites: " + NumberFormatter.addCommas((Number)numDaoCallsites) + "\n");
        sb.append("    first date: " + firstDate.toString() + "\n");
        sb.append("     last date: " + lastDate.toString() + "\n");
        sb.append("       seconds: " + NumberFormatter.addCommas((Number)numSeconds) + "\n");
        sb.append("     calls/sec: " + NumberFormatter.format((Number)callsPerSec, (int)2) + "\n");
        sb.append("\n");
        int rankWidth = 5;
        sb.append(String.valueOf(StringTool.pad((String)"rank", (char)' ', (int)rankWidth)) + CallsiteStat.getReportHeader(reportMetadata) + "\n");
        int row = 0;
        for (CallsiteStat stat : stats) {
            if (++row > this.maxResults) break;
            sb.append(String.valueOf(StringTool.pad((String)String.valueOf(row), (char)' ', (int)rankWidth)) + stat.getReportLine(reportMetadata) + "\n");
        }
        return sb.toString();
    }
}

