/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.callsite;

import io.datarouter.util.DateTool;
import java.util.Date;

public class CallsiteRecord {
    private Date timestamp;
    private String nodeName;
    private String datarouterMethodName;
    private String callsite;
    private long numItems;
    private long durationNs;

    public CallsiteRecord(Date timestamp, String nodeName, String datarouterMethodName, String callsite, long numItems, long durationNs) {
        this.timestamp = timestamp;
        this.nodeName = nodeName;
        this.datarouterMethodName = datarouterMethodName;
        this.callsite = callsite;
        this.numItems = numItems;
        this.durationNs = durationNs;
    }

    public String getLogMessage() {
        long durationUs = this.durationNs / 1000L;
        String message = String.valueOf(this.nodeName) + " " + this.datarouterMethodName + " " + this.callsite + " " + this.numItems + " " + durationUs;
        return message;
    }

    public static CallsiteRecord fromLogLine(String line) {
        String[] allTokens = line.split(" ");
        String dateTime = String.valueOf(allTokens[0]) + " " + allTokens[1];
        Date timestamp = DateTool.parseUserInputDate((String)dateTime, (Integer)2014);
        String afterThreadName = line.substring(line.indexOf("]") + 1);
        String[] lineTokens = afterThreadName.split(" ");
        int index = 3;
        String nodeName = lineTokens[index++];
        String datarouterMethodName = lineTokens[index++];
        String callsite = lineTokens[index++];
        Integer numItems = Integer.valueOf(lineTokens[index++]);
        Long microseconds = Long.valueOf(lineTokens[index++]);
        Long nanoseconds = 1000L * microseconds;
        return new CallsiteRecord(timestamp, nodeName, datarouterMethodName, callsite, numItems.intValue(), nanoseconds);
    }

    public long getDurationUs() {
        return this.durationNs / 1000L;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getDatarouterMethodName() {
        return this.datarouterMethodName;
    }

    public String getCallsite() {
        return this.callsite;
    }

    public long getNumItems() {
        return this.numItems;
    }

    public long getDurationNs() {
        return this.durationNs;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }
}

