/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.callsite;

import io.datarouter.storage.callsite.CallsiteReportHeader;
import io.datarouter.storage.callsite.CallsiteStatKey;
import io.datarouter.storage.callsite.CallsiteStatReportMetadata;
import io.datarouter.util.iterable.IterableTool;
import io.datarouter.util.number.NumberFormatter;
import io.datarouter.util.string.StringTool;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class CallsiteStat {
    private static final String DAO_CALLSITE_INDICATOR = "dao";
    private static final int DAO_CALLSITE_INDICATOR_LENGTH = Math.max(CallsiteReportHeader.type.length(), "dao".length());
    private static final Set<String> HIDE_TIME_METHODS = Set.of("scanKeys", "scan");
    private CallsiteStatKey key;
    private String datarouterMethodName;
    private Long count;
    private Long durationNs;
    private Long numItems;

    public CallsiteStat(String callsite, String nodeName, String datarouterMethodName, Long count, Long durationNs, Long numItems) {
        this.key = new CallsiteStatKey(callsite, nodeName);
        this.datarouterMethodName = datarouterMethodName;
        this.count = count;
        this.durationNs = durationNs;
        this.numItems = numItems;
    }

    public static String getReportHeader(CallsiteStatReportMetadata metadata) {
        return CallsiteStat.buildReportLine(metadata, CallsiteReportHeader.count.toString(), CallsiteReportHeader.microSec.toString(), CallsiteReportHeader.avgMicroSec.toString(), CallsiteReportHeader.numItems.toString(), CallsiteReportHeader.avgItems.toString(), CallsiteReportHeader.type.toString(), CallsiteReportHeader.node.toString(), CallsiteReportHeader.method.toString(), CallsiteReportHeader.callsite.toString());
    }

    public String getReportLine(CallsiteStatReportMetadata metadata) {
        String countString = NumberFormatter.addCommas((Number)this.count);
        boolean hideDuration = HIDE_TIME_METHODS.contains(this.datarouterMethodName);
        String durationString = hideDuration ? "" : NumberFormatter.addCommas((Number)this.getDurationUs());
        String avgCallUsString = hideDuration ? "" : NumberFormatter.addCommas((Number)(this.getDurationUs() / this.count));
        String numItemsString = NumberFormatter.addCommas((Number)this.numItems);
        String avgItemsString = NumberFormatter.addCommas((Number)(this.numItems / this.count));
        String type = this.isDaoCallsite() ? DAO_CALLSITE_INDICATOR : StringTool.repeat((char)' ', (int)DAO_CALLSITE_INDICATOR_LENGTH);
        return CallsiteStat.buildReportLine(metadata, countString, durationString, avgCallUsString, numItemsString, avgItemsString, type, this.key.getNodeName(), this.datarouterMethodName, this.key.getCallsite());
    }

    private static String buildReportLine(CallsiteStatReportMetadata reportMetadata, String count, String durationUs, String avgCallUs, String numItems, String avgItems, String type, String nodeName, String drMethod, String callsite) {
        StringBuilder sb = new StringBuilder();
        sb.append(StringTool.pad((String)count, (char)' ', (int)(2 + reportMetadata.getCountLength())));
        sb.append(StringTool.pad((String)durationUs, (char)' ', (int)(2 + reportMetadata.getDurationUsLength())));
        sb.append(StringTool.pad((String)avgCallUs, (char)' ', (int)(2 + reportMetadata.getAvgDurationUsLength())));
        sb.append(StringTool.pad((String)numItems, (char)' ', (int)(2 + reportMetadata.getItemsLength())));
        sb.append(StringTool.pad((String)avgItems, (char)' ', (int)(2 + reportMetadata.getAvgItemsLength())));
        sb.append(StringTool.pad((String)type, (char)' ', (int)(2 + DAO_CALLSITE_INDICATOR_LENGTH)));
        sb.append("  ");
        sb.append(StringTool.padEnd((String)nodeName, (char)' ', (int)(2 + reportMetadata.getWidthNodeName())));
        sb.append(StringTool.padEnd((String)drMethod, (char)' ', (int)(2 + reportMetadata.getWidthDatarouterMethod())));
        sb.append(callsite);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CallsiteStat other = (CallsiteStat)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public String toString() {
        String countString = NumberFormatter.addCommas((Number)this.count);
        return String.valueOf(StringTool.pad((String)countString, (char)' ', (int)8)) + "   " + this.key.getCallsite();
    }

    public void addMetrics(CallsiteStat other) {
        this.count = this.count + other.count;
        this.durationNs = this.durationNs + other.durationNs;
        this.numItems = this.numItems + other.numItems;
    }

    public Long getDurationUs() {
        return this.durationNs / 1000L;
    }

    public boolean isDaoCallsite() {
        return this.key.getCallsite().toLowerCase().contains(DAO_CALLSITE_INDICATOR);
    }

    public static int countDaoCallsites(List<CallsiteStat> stats) {
        int numDaoCallsites = 0;
        for (CallsiteStat stat : IterableTool.nullSafe(stats)) {
            if (!stat.isDaoCallsite()) continue;
            ++numDaoCallsites;
        }
        return numDaoCallsites;
    }

    public Long getAvgDurationUs() {
        return this.durationNs / this.count;
    }

    public Long getAvgItems() {
        return this.numItems / this.count;
    }

    public Long getCount() {
        return this.count;
    }

    public CallsiteStatKey getKey() {
        return this.key;
    }

    public Long getDurationNs() {
        return this.durationNs;
    }

    public Long getNumItems() {
        return this.numItems;
    }

    public String getDatarouterMethodName() {
        return this.datarouterMethodName;
    }

    public static class CallsiteCountComparator
    implements Comparator<CallsiteStat> {
        @Override
        public int compare(CallsiteStat callsiteA, CallsiteStat callsiteB) {
            return callsiteA.count.compareTo(callsiteB.count);
        }
    }

    public static class CallsiteDurationComparator
    implements Comparator<CallsiteStat> {
        @Override
        public int compare(CallsiteStat callsiteA, CallsiteStat callsiteB) {
            return callsiteA.durationNs.compareTo(callsiteB.durationNs);
        }
    }
}

