/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.client;

import io.datarouter.util.collection.CollectionTool;
import io.datarouter.util.collection.ListTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ClientId
implements Comparable<ClientId> {
    private final String name;
    private final boolean writable;
    private final boolean disableable;

    public ClientId(String name, boolean writable) {
        this(name, writable, true);
    }

    public ClientId(String name, boolean writable, boolean disableable) {
        this.name = name;
        this.writable = writable;
        this.disableable = disableable;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.writable, this.disableable);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClientId)) {
            return false;
        }
        ClientId other = (ClientId)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.writable != other.writable) {
            return false;
        }
        return this.disableable == other.disableable;
    }

    @Override
    public int compareTo(ClientId other) {
        int diff = this.name.compareTo(other.name);
        if (diff != 0) {
            return diff;
        }
        diff = Boolean.compare(this.writable, other.writable);
        if (diff != 0) {
            return diff;
        }
        return Boolean.compare(this.disableable, this.disableable);
    }

    public String toString() {
        return "ClientId[" + this.name + "," + this.writable + "," + this.disableable + "]";
    }

    public static List<String> getNames(Collection<ClientId> ids) {
        ArrayList names = ListTool.createArrayListWithSize(ids);
        for (ClientId id : CollectionTool.nullSafe(ids)) {
            names.add(id.name);
        }
        return names;
    }

    public static List<String> getWritableNames(Collection<ClientId> ids) {
        ArrayList names = ListTool.createArrayListWithSize(ids);
        for (ClientId id : CollectionTool.nullSafe(ids)) {
            if (!id.writable) continue;
            names.add(id.name);
        }
        return names;
    }

    public String getName() {
        return this.name;
    }

    public boolean getWritable() {
        return this.writable;
    }

    public boolean getDisableable() {
        return this.disableable;
    }
}

