/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.client;

import io.datarouter.storage.client.ClientId;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;

@Singleton
public class ClientInitializationTracker {
    private final Set<ClientId> initializedClients = ConcurrentHashMap.newKeySet();

    public void setInitialized(ClientId clientId) {
        if (!this.initializedClients.add(clientId)) {
            throw new RuntimeException(clientId + " was already initialized");
        }
    }

    public boolean isInitialized(ClientId clientId) {
        return this.initializedClients.contains(clientId);
    }

    public Set<ClientId> getInitializedClients() {
        return this.initializedClients;
    }
}

