/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.client;

import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientInitMode;
import io.datarouter.util.properties.TypedProperties;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiFunction;
import javax.inject.Singleton;

@Singleton
public class ClientOptions {
    private static final String PREFIX_client = "client.";
    private static final String PARAM_initMode = "initMode";
    private static final String PARAM_type = "type";
    private static final String CLIENT_default = "default";
    private final TypedProperties typedProperties = new TypedProperties();

    public void addProperties(Properties properties) {
        this.typedProperties.addProperties(properties);
    }

    public ClientInitMode getInitMode(ClientId clientId, ClientInitMode def) {
        return ClientOptions.getClientPropertyOrDefault((key, defaultValue) -> ClientInitMode.fromString(this.typedProperties.getString(key), defaultValue), PARAM_initMode, clientId.getName(), def);
    }

    public String getClientType(ClientId clientId) {
        return this.getRequiredString(clientId.getName(), PARAM_type);
    }

    public String getRequiredString(String clientName, String propertyKey) {
        return this.typedProperties.getRequiredString(ClientOptions.makeClientPrefixedKey(clientName, propertyKey));
    }

    public Integer getRequiredInteger(String clientName, String propertyKey) {
        return this.typedProperties.getRequiredInteger(ClientOptions.makeClientPrefixedKey(clientName, propertyKey));
    }

    public Optional<String> optString(String clientName, String propertyKey) {
        return this.typedProperties.optString(ClientOptions.makeClientPrefixedKey(clientName, propertyKey));
    }

    public Optional<InetSocketAddress> optInetSocketAddress(String clientName, String propertyKey) {
        return this.typedProperties.optInetSocketAddress(ClientOptions.makeClientPrefixedKey(clientName, propertyKey));
    }

    public String getStringClientPropertyOrDefault(String propertyKey, String clientName, String def) {
        return ClientOptions.getClientPropertyOrDefault((arg_0, arg_1) -> ((TypedProperties)this.typedProperties).getString(arg_0, arg_1), propertyKey, clientName, def);
    }

    public Integer getIntegerClientPropertyOrDefault(String propertyKey, String clientName, Integer def) {
        return ClientOptions.getClientPropertyOrDefault((arg_0, arg_1) -> ((TypedProperties)this.typedProperties).getInteger(arg_0, arg_1), propertyKey, clientName, def);
    }

    public Boolean getBooleanClientPropertyOrDefault(String propertyKey, String clientName, Boolean def) {
        return ClientOptions.getClientPropertyOrDefault((arg_0, arg_1) -> ((TypedProperties)this.typedProperties).getBoolean(arg_0, arg_1), propertyKey, clientName, def);
    }

    public static String makeClientTypeKey(String clientName) {
        return ClientOptions.makeClientPrefixedKey(clientName, PARAM_type);
    }

    public static String makeClientInitModeKey(String clientName) {
        return ClientOptions.makeClientPrefixedKey(clientName, PARAM_initMode);
    }

    public static String makeClientPrefixedKey(String clientName, String propertyKey) {
        return PREFIX_client + clientName + "." + propertyKey;
    }

    private static <T> T getClientPropertyOrDefault(BiFunction<String, T, T> propertyGetter, String propertyKey, String clientName, T def) {
        T defaultValue = propertyGetter.apply(ClientOptions.makeClientPrefixedKey(CLIENT_default, propertyKey), (String)def);
        return propertyGetter.apply(ClientOptions.makeClientPrefixedKey(clientName, propertyKey), (String)defaultValue);
    }
}

