/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.client;

import io.datarouter.storage.client.ClientOptionsBuilder;
import io.datarouter.util.collection.ListTool;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.inject.Singleton;

public interface ClientOptionsFactory {
    public Properties getInternalConfigDirectoryTypeOptions(String var1);

    default public Properties mergeOptions(Properties ... options) {
        return Arrays.stream(options).collect(Properties::new, Map::putAll, Map::putAll);
    }

    default public Properties mergeBuilders(Collection<ClientOptionsBuilder> builders) {
        Properties[] multiProperties = (Properties[])builders.stream().map(ClientOptionsBuilder::build).toArray(Properties[]::new);
        return this.mergeOptions(multiProperties);
    }

    default public Properties mergeBuilders(ClientOptionsBuilder ... builders) {
        return this.mergeBuilders(Arrays.asList(builders));
    }

    default public Properties mergeBuilders(Collection<ClientOptionsBuilder> builderCollection, ClientOptionsBuilder ... builderVarargs) {
        return this.mergeBuilders(ListTool.concatenate(builderCollection, Arrays.asList(builderVarargs)));
    }

    @Singleton
    public static class NoOpClientOptionsFactory
    implements ClientOptionsFactory {
        @Override
        public Properties getInternalConfigDirectoryTypeOptions(String internalConfigDirectoryTypeName) {
            return new Properties();
        }
    }
}

