/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.client;

import io.datarouter.inject.DatarouterInjector;
import io.datarouter.storage.client.ClientType;
import io.datarouter.util.lang.ClassTool;
import io.datarouter.util.lazy.Lazy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ClientTypeRegistry {
    private static final String CLIENT_TYPE_CLASS_NAME_LOCATION = "META-INF/datarouter/clientTypes";
    private final Lazy<Map<String, ClientType<?, ?>>> clientTypesByName = Lazy.of(() -> ClientTypeRegistry.streamClientType().map(ClientTypeRegistry::listLines).flatMap(Collection::stream).distinct().map(ClassTool::forName).map(clientTypeClass -> clientTypeClass.asSubclass(ClientType.class)).map(arg_0 -> ((DatarouterInjector)injector).getInstance(arg_0)).collect(Collectors.toMap(ClientType::getName, Function.identity())));

    @Inject
    public ClientTypeRegistry(DatarouterInjector injector) {
    }

    private static Stream<URL> streamClientType() {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return Collections.list(classLoader.getResources(CLIENT_TYPE_CLASS_NAME_LOCATION)).stream();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ClientType<?, ?> get(String name) {
        return (ClientType)((Map)this.clientTypesByName.get()).get(name);
    }

    private static List<String> listLines(URL url) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                return reader.lines().collect(Collectors.toList());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

