/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.config;

import io.datarouter.storage.config.ConfigKey;
import io.datarouter.storage.config.ConfigValue;
import io.datarouter.storage.config.PutMethod;
import io.datarouter.util.Require;
import io.datarouter.util.lang.LineOfCode;
import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class Config
implements Cloneable {
    public static final int DEFAULT_INPUT_BATCH_SIZE = 100;
    public static final int DEFAULT_OUTPUT_BATCH_SIZE = 100;
    public static final Boolean DEFAULT_CACHE_OK = true;
    private Boolean useSession = true;
    private Boolean slaveOk = false;
    private PutMethod putMethod = PutMethod.DEFAULT_PUT_METHOD;
    private Boolean ignoreNullFields;
    private Integer commitBatchSize;
    private Boolean persistentPut = true;
    private Boolean scannerCaching;
    private Integer inputBatchSize;
    private Integer outputBatchSize;
    private Boolean ignoreException;
    private Duration timeout = Duration.ofMinutes(10L);
    private Integer numAttempts;
    private Integer limit;
    private Integer offset;
    private Boolean cacheOk = DEFAULT_CACHE_OK;
    private Duration ttl;
    private Long visibilityTimeoutMs;
    private LineOfCode callsite;
    private LineOfCode customCallsite;
    private final Map<ConfigKey<?>, ConfigValue<?>> configuration = new HashMap();

    public Config addOption(ConfigValue<?> option) {
        this.configuration.put(option.getKey(), option);
        return this;
    }

    public final <T extends ConfigValue<T>> Optional<T> getOption(ConfigKey<T> key) {
        return Optional.ofNullable(this.configuration.get(key));
    }

    public Config clone() {
        return this.getDeepCopy();
    }

    public Config getDeepCopy() {
        Config clone = new Config();
        clone.setUseSession(this.useSession).setSlaveOk(this.slaveOk).setPutMethod(this.putMethod).setIgnoreNullFields(this.ignoreNullFields).setCommitBatchSize(this.commitBatchSize).setPersistentPut(this.persistentPut).setScannerCaching(this.scannerCaching).setInputBatchSize(this.inputBatchSize).setOutputBatchSize(this.outputBatchSize).setIgnoreException(this.ignoreException).setTimeout(this.timeout).setNumAttempts(this.numAttempts).setLimit(this.limit).setOffset(this.offset).setCacheOk(this.cacheOk).setTtl(this.ttl).setVisibilityTimeoutMs(this.visibilityTimeoutMs).setCallsite(this.callsite).setCustomCallsite(this.customCallsite);
        this.configuration.values().forEach(clone::addOption);
        return clone;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Optional<Integer> optLimit() {
        return Optional.ofNullable(this.limit);
    }

    public Config setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Optional<Integer> optOffset() {
        return Optional.ofNullable(this.offset);
    }

    public Config setOffset(Integer offset) {
        this.offset = offset;
        return this;
    }

    public Optional<Integer> optInputBatchSize() {
        return Optional.ofNullable(this.inputBatchSize);
    }

    public Config setInputBatchSize(Integer inputBatchSize) {
        Require.isTrue((inputBatchSize == null || inputBatchSize > 0 ? 1 : 0) != 0);
        this.inputBatchSize = inputBatchSize;
        return this;
    }

    public Optional<Integer> optOutputBatchSize() {
        return Optional.ofNullable(this.outputBatchSize);
    }

    public Config setOutputBatchSize(Integer outputBatchSize) {
        Require.isTrue((outputBatchSize == null || outputBatchSize > 0 ? 1 : 0) != 0);
        this.outputBatchSize = outputBatchSize;
        return this;
    }

    public Integer getCommitBatchSize() {
        return this.commitBatchSize;
    }

    public Config setCommitBatchSize(Integer commitBatchSize) {
        this.commitBatchSize = commitBatchSize;
        return this;
    }

    public Boolean getSlaveOk() {
        return this.slaveOk;
    }

    public Config setSlaveOk(Boolean slaveOk) {
        this.slaveOk = slaveOk;
        return this;
    }

    public Boolean getCacheOk() {
        return this.cacheOk;
    }

    public Config setCacheOk(Boolean cacheOk) {
        this.cacheOk = cacheOk;
        return this;
    }

    public Boolean getUseSession() {
        return this.useSession;
    }

    public Config setUseSession(Boolean useSession) {
        this.useSession = useSession;
        return this;
    }

    public Integer getNumAttempts() {
        return this.numAttempts;
    }

    public Integer getNumAttemptsOrUse(int alternative) {
        if (this.numAttempts != null) {
            return this.numAttempts;
        }
        return alternative;
    }

    public Config setNumAttempts(Integer numAttempts) {
        this.numAttempts = numAttempts;
        return this;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public Duration getTimeoutOrUse(Duration alternative) {
        return this.timeout == null ? alternative : this.timeout;
    }

    public Config setTimeout(Integer timeout, TemporalUnit temporalUnit) {
        this.timeout = Duration.of(timeout.intValue(), temporalUnit);
        return this;
    }

    public Config setTimeout(Duration duration) {
        this.timeout = duration;
        return this;
    }

    public Config setNoTimeout() {
        this.setTimeout(Duration.ofMillis(Long.MAX_VALUE));
        return this;
    }

    public PutMethod getPutMethod() {
        return this.putMethod;
    }

    public Config setPutMethod(PutMethod putMethod) {
        this.putMethod = putMethod;
        return this;
    }

    public Optional<Boolean> optIgnoreNullFields() {
        return Optional.ofNullable(this.ignoreNullFields);
    }

    public Config setIgnoreNullFields(Boolean ignoreNullFields) {
        this.ignoreNullFields = ignoreNullFields;
        return this;
    }

    public Optional<Boolean> optScannerCaching() {
        return Optional.ofNullable(this.scannerCaching);
    }

    public Config setScannerCaching(Boolean scannerCaching) {
        this.scannerCaching = scannerCaching;
        return this;
    }

    public Boolean getPersistentPut() {
        return this.persistentPut;
    }

    public Config setPersistentPut(Boolean persistentPut) {
        this.persistentPut = persistentPut;
        return this;
    }

    public Duration getTtl() {
        return this.ttl;
    }

    public Config setTtl(Duration ttl) {
        this.ttl = ttl;
        return this;
    }

    public long getVisibilityTimeoutMsOrUse(long alternative) {
        if (this.visibilityTimeoutMs != null) {
            return this.visibilityTimeoutMs;
        }
        return alternative;
    }

    public Long getVisibilityTimeoutMs() {
        return this.visibilityTimeoutMs;
    }

    public Config setVisibilityTimeoutMs(Long visibilityTimeoutMs) {
        this.visibilityTimeoutMs = visibilityTimeoutMs;
        return this;
    }

    public LineOfCode getCallsite() {
        return this.callsite;
    }

    public Config setCallsite(LineOfCode callsite) {
        this.callsite = callsite;
        return this;
    }

    public LineOfCode getCustomCallsite() {
        return this.customCallsite;
    }

    public Config setCustomCallsite(LineOfCode customCallsite) {
        this.customCallsite = customCallsite;
        return this;
    }

    public Boolean getIgnoreException() {
        return this.ignoreException;
    }

    public Config setIgnoreException(Boolean paramIgnoreException) {
        this.ignoreException = paramIgnoreException;
        return this;
    }

    public Boolean ignoreExceptionOrUse(Boolean alternative) {
        if (this.ignoreException != null) {
            return this.ignoreException;
        }
        return alternative;
    }
}

