/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.config;

import io.datarouter.storage.config.DatarouterAdditionalAdministratorsSupplier;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.storage.config.setting.DatarouterAdminEmailSettings;
import io.datarouter.util.EmailTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterAdministratorEmailService {
    @Inject
    private DatarouterProperties datarouterProperties;
    @Inject
    private DatarouterAdditionalAdministratorsSupplier additionalAdministrators;
    @Inject
    private DatarouterAdminEmailSettings adminEmailSettings;

    public List<String> getAdministratorEmailAddresses() {
        ArrayList<String> administrators = new ArrayList<String>();
        administrators.add(this.datarouterProperties.getAdministratorEmail());
        if (((Boolean)this.adminEmailSettings.includeAdditionalAdministratorsEmails.get()).booleanValue()) {
            administrators.addAll((Collection)this.additionalAdministrators.get());
        }
        return administrators;
    }

    public String getAdministratorEmailAddressesCsv() {
        return String.join((CharSequence)",", this.getAdministratorEmailAddresses());
    }

    public String getAdministratorEmailAddressesCsv(String ... additionalEmailAddresses) {
        return this.getAdministratorEmailAddressesCsv(Set.of(additionalEmailAddresses));
    }

    public String getAdministratorEmailAddressesCsv(Set<String> additionalEmailAddresses) {
        List<String> emails = this.getAdministratorEmailAddresses();
        emails.addAll(additionalEmailAddresses);
        return String.join((CharSequence)",", emails);
    }

    public String getAdministratorEmailWithSupplement(String supplement) {
        return EmailTool.addSupplementToEmailAddress((String)this.datarouterProperties.getAdministratorEmail(), (String)supplement);
    }
}

