/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.config;

import io.datarouter.storage.config.Ec2InstanceDetailsDto;
import io.datarouter.storage.config.environment.EnvironmentType;
import io.datarouter.storage.servertype.ServerType;
import io.datarouter.storage.servertype.ServerTypes;
import io.datarouter.util.Require;
import io.datarouter.util.collection.CollectionTool;
import io.datarouter.util.io.FileTool;
import io.datarouter.util.io.ReaderTool;
import io.datarouter.util.properties.PropertiesTool;
import io.datarouter.util.serialization.GsonTool;
import io.datarouter.util.string.StringTool;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatarouterProperties {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterProperties.class);
    private static final String JVM_ARG_PREFIX = "datarouter.";
    private static final String CONFIG_DIRECTORY_PROP = "config.directory";
    private static final String ENVIRONMENT = "environment";
    private static final String ENVIRONMENT_DOMAIN = "environmentDomain";
    private static final String ENVIRONMENT_TYPE = "environmentType";
    private static final String SERVER_PUBLIC_IP = "server.publicIp";
    private static final String SERVER_PRIVATE_IP = "server.privateIp";
    private static final String SERVER_NAME = "server.name";
    private static final String SERVER_TYPE = "server.type";
    private static final String SERVER_CLUSTER_DOMAINS = "server.clusterDomains";
    private static final String ADMINISTRATOR_EMAIL = "administrator.email";
    private static final String INTERNAL_CONFIG_DIRECTORY_PROP = "internalConfigDirectory";
    private static final String EC2_INSTANCE_IDENTITY_DOCUMENT_URL = "http://169.254.169.254/latest/dynamic/instance-identity/document";
    private static final String EC2_PRIVATE_IP_URL = "http://169.254.169.254/latest/meta-data/local-ipv4";
    private static final String EC2_PUBLIC_IP_URL = "http://169.254.169.254/latest/meta-data/public-ipv4";
    private final String webappName;
    protected final String configDirectory;
    protected final String configFileLocation;
    private final String environment;
    private final String environmentDomain;
    private final String environmentType;
    private final String serverName;
    private final ServerType serverType;
    private final String administratorEmail;
    private final String privateIp;
    private final String publicIp;
    private final Collection<String> clusterDomains;
    private final String internalConfigDirectory;

    protected DatarouterProperties(ServerTypes serverTypeOptions, String serviceName, String configDirectory, String filename) {
        this(serverTypeOptions, serviceName, configDirectory, true, false, filename, true);
    }

    private DatarouterProperties(ServerTypes serverTypeOptions, String webappName, String configDirectory, boolean directoryRequired, boolean directoryFromJvmArg, String filename, boolean fileRequired) {
        boolean fileRequiredWithoutDirectoryRequired = fileRequired && !directoryRequired;
        Require.isTrue((!fileRequiredWithoutDirectoryRequired ? 1 : 0) != 0, (String)"directory is required if file is required");
        this.webappName = webappName;
        this.configDirectory = configDirectory;
        if (configDirectory != null) {
            FileTool.createFileParents((String)(String.valueOf(configDirectory) + "/anything"));
            if (directoryFromJvmArg) {
                this.logJvmArgSource(CONFIG_DIRECTORY_PROP, configDirectory, "datarouter.config.directory");
            } else {
                this.logSource(CONFIG_DIRECTORY_PROP, configDirectory, "constant");
            }
        } else {
            Require.isTrue((!directoryRequired ? 1 : 0) != 0, (String)"configDirectory required but not found");
        }
        if (StringTool.isEmpty((String)filename)) {
            Require.isTrue((!fileRequired ? 1 : 0) != 0);
            this.configFileLocation = null;
        } else {
            this.configFileLocation = String.valueOf(configDirectory) + "/" + filename;
        }
        if (this.configFileLocation != null) {
            this.logSource("config file", this.configFileLocation, "constant");
        }
        Optional<Properties> configFileProperties = Optional.empty();
        if (this.configFileLocation != null) {
            try {
                configFileProperties = Optional.of(PropertiesTool.parse((String)this.configFileLocation));
                this.logConfigFileProperties(configFileProperties);
            }
            catch (Exception e) {
                logger.error("couldn't parse properties file {}", (Object)this.configFileLocation);
            }
        }
        this.environment = this.findProperty(configFileProperties, ENVIRONMENT);
        this.environmentDomain = this.findProperty(configFileProperties, ENVIRONMENT_DOMAIN);
        this.environmentType = this.findEnvironmentType(configFileProperties);
        this.serverName = this.findServerName(configFileProperties);
        this.serverType = serverTypeOptions.fromPersistentString(this.findProperty(configFileProperties, SERVER_TYPE));
        this.administratorEmail = this.findProperty(configFileProperties, ADMINISTRATOR_EMAIL);
        this.privateIp = this.findPrivateIp(configFileProperties);
        this.publicIp = this.findPublicIp(configFileProperties);
        this.clusterDomains = this.findClusterDomains(configFileProperties);
        this.internalConfigDirectory = this.findProperty(configFileProperties, INTERNAL_CONFIG_DIRECTORY_PROP);
    }

    private String findProperty(Optional<Properties> configFileProperties, String propertyName) {
        Optional<String> value;
        Optional<String> jvmValue = this.getJvmArg(propertyName);
        if (jvmValue.isPresent()) {
            return jvmValue.get();
        }
        if (configFileProperties.isPresent() && (value = configFileProperties.map(properties -> properties.getProperty(propertyName))).isPresent()) {
            this.logSource(propertyName, value.get(), this.configFileLocation);
            return value.get();
        }
        logger.error("couldn't find {}", (Object)propertyName);
        return null;
    }

    private String findEnvironmentType(Optional<Properties> configFileProperties) {
        String environmentType = this.findProperty(configFileProperties, ENVIRONMENT_TYPE);
        if (environmentType != null) {
            return environmentType;
        }
        String defaultValue = EnvironmentType.DEVELOPMENT.get().getPersistentString();
        logger.error("couldn't find {}, defaulting to {}", (Object)ENVIRONMENT_TYPE, (Object)defaultValue);
        return defaultValue;
    }

    private String findServerName(Optional<Properties> configFileProperties) {
        String serverName = this.findProperty(configFileProperties, SERVER_NAME);
        if (serverName != null) {
            return serverName;
        }
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            String source = "InetAddress.getLocalHost().getHostName()";
            if (hostname.contains(".")) {
                hostname = hostname.substring(0, hostname.indexOf(46));
                source = String.valueOf(source) + ".substring(0, hostname.indexOf('.')";
            }
            this.logSource(SERVER_NAME, hostname, source);
            return hostname;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    private String findPrivateIp(Optional<Properties> configFileProperties) {
        String privateIp = this.findProperty(configFileProperties, SERVER_PRIVATE_IP);
        if (privateIp != null) {
            return privateIp;
        }
        Optional<String> ip = this.curl(EC2_PRIVATE_IP_URL, true);
        if (ip.isPresent()) {
            this.logSource(SERVER_PRIVATE_IP, ip.get(), EC2_PRIVATE_IP_URL);
            return ip.get();
        }
        logger.error("couldn't find {}", (Object)SERVER_PRIVATE_IP);
        return null;
    }

    private String findPublicIp(Optional<Properties> configFileProperties) {
        String publicIp = this.findProperty(configFileProperties, SERVER_PUBLIC_IP);
        if (publicIp != null) {
            return publicIp;
        }
        Optional<String> ip = this.curl(EC2_PUBLIC_IP_URL, true);
        if (ip.isPresent()) {
            this.logSource(SERVER_PUBLIC_IP, ip.get(), EC2_PUBLIC_IP_URL);
            return ip.get();
        }
        logger.error("couldn't find {}", (Object)SERVER_PUBLIC_IP);
        return null;
    }

    private Collection<String> findClusterDomains(Optional<Properties> configFileProperties) {
        Optional<String> value;
        Optional<String> jvmValue = this.getJvmArg(SERVER_CLUSTER_DOMAINS);
        if (jvmValue.isPresent()) {
            return this.parseClusterDomains(jvmValue.get());
        }
        if (configFileProperties.isPresent() && (value = configFileProperties.map(properties -> properties.getProperty(SERVER_CLUSTER_DOMAINS))).isPresent()) {
            this.logSource(SERVER_CLUSTER_DOMAINS, value.get(), this.configFileLocation);
            return value.map(this::parseClusterDomains).get();
        }
        logger.error("couldn't find {}", (Object)SERVER_CLUSTER_DOMAINS);
        return Collections.emptyList();
    }

    private Optional<String> getJvmArg(String jvmArg) {
        String jvmArgName = JVM_ARG_PREFIX + jvmArg;
        String jvmArgValue = System.getProperty(jvmArgName);
        if (jvmArgValue == null) {
            return Optional.empty();
        }
        this.logJvmArgSource(jvmArg, jvmArgValue, jvmArgName);
        return Optional.of(jvmArgValue);
    }

    private void logConfigFileProperties(Optional<Properties> configFileProperties) {
        configFileProperties.get().stringPropertyNames().stream().map(name -> String.valueOf(name) + "=" + ((Properties)configFileProperties.get()).getProperty((String)name)).sorted().forEach(arg_0 -> ((Logger)logger).info(arg_0));
    }

    private void logSource(String name, String value, String source) {
        logger.warn("found {}={} from {}", new Object[]{name, value, source});
    }

    private void logJvmArgSource(String name, String value, String jvmArgName) {
        logger.warn("found {}={} from -D{} JVM arg", new Object[]{name, value, jvmArgName});
    }

    private Optional<String> curl(String location, boolean logError) {
        try {
            URL url = new URL(location);
            InputStreamReader reader = new InputStreamReader(url.openStream(), "UTF-8");
            String content = ReaderTool.accumulateStringAndClose((Reader)reader);
            return Optional.of(content);
        }
        catch (Exception e) {
            if (logError) {
                logger.error("error reading {}", (Object)location, (Object)e);
            }
            return Optional.empty();
        }
    }

    private Collection<String> parseClusterDomains(String clusterDomainsProperty) {
        if (StringTool.isNullOrEmptyOrWhitespace((String)clusterDomainsProperty)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Stream.of(clusterDomainsProperty.split(",")).filter(StringTool::notEmptyNorWhitespace).map(String::trim).collect(Collectors.toList()));
    }

    public String getServerTypeString() {
        return Optional.ofNullable(this.serverType).map(ServerType::getPersistentString).orElse(null);
    }

    public String findConfigFile(String filename) {
        String externalLocation = String.valueOf(this.configDirectory) + "/" + filename;
        if (Files.exists(Paths.get(externalLocation, new String[0]), new LinkOption[0])) {
            return externalLocation;
        }
        Objects.requireNonNull(this.internalConfigDirectory, String.valueOf(externalLocation) + " doesn't exist and " + INTERNAL_CONFIG_DIRECTORY_PROP + " property is not set");
        return "/config/" + this.internalConfigDirectory + "/" + filename;
    }

    public Optional<Ec2InstanceDetailsDto> getEc2InstanceDetails() {
        Optional<String> ec2InstanceIdentityDocumentResponse = this.curl(EC2_INSTANCE_IDENTITY_DOCUMENT_URL, false);
        return ec2InstanceIdentityDocumentResponse.map(json -> (Ec2InstanceDetailsDto)GsonTool.GSON.fromJson(json, Ec2InstanceDetailsDto.class));
    }

    public String getServerName() {
        return this.serverName;
    }

    public ServerType getServerType() {
        return this.serverType;
    }

    public String getServerPublicIp() {
        return this.publicIp;
    }

    public String getServerPrivateIp() {
        return this.privateIp;
    }

    public Collection<String> getServerClusterDomains() {
        return this.clusterDomains;
    }

    public String getAdministratorEmail() {
        return this.administratorEmail;
    }

    public String getConfigDirectory() {
        return this.configDirectory;
    }

    public String getConfigFileLocation() {
        return this.configFileLocation;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getEnvironmentDomain() {
        return this.environmentDomain;
    }

    public String getEnvironmentType() {
        return this.environmentType;
    }

    public String getWebappName() {
        return this.webappName;
    }

    public String getFirstServerClusterDomain() {
        return (String)CollectionTool.getFirst(this.getServerClusterDomains());
    }

    public String getInternalConfigDirectory() {
        return this.internalConfigDirectory;
    }

    public abstract String getDatarouterPropertiesFileLocation();
}

