/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.config;

import io.datarouter.storage.client.ClientOptionsFactory;
import io.datarouter.storage.config.BasePlugin;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.storage.config.setting.DatarouterSettingOverrides;
import io.datarouter.storage.config.setting.DatarouterStorageSettingRoot;
import io.datarouter.storage.dao.Dao;
import io.datarouter.storage.dao.DaoClasses;
import io.datarouter.storage.servertype.ServerTypeDetector;
import io.datarouter.storage.servertype.ServerTypes;
import io.datarouter.storage.setting.AdditionalSettingRoots;
import io.datarouter.storage.setting.AdditionalSettingRootsSupplier;
import java.util.ArrayList;
import java.util.List;

public class DatarouterStoragePlugin
extends BasePlugin {
    private final ServerTypes serverTypes;
    private final Class<? extends ServerTypeDetector> serverTypeDetectorClass;
    private final DatarouterProperties datarouterProperties;
    private final Class<? extends DatarouterSettingOverrides> settingOverridesClass;
    private final AdditionalSettingRoots additionalSettingRoots;
    private final Class<? extends ClientOptionsFactory> clientOptionsFactoryClass;
    private final List<Class<? extends Dao>> daoClasses;

    private DatarouterStoragePlugin() {
        this(null, null, null, null, null, null, null);
    }

    private DatarouterStoragePlugin(ServerTypes serverTypes, Class<? extends ServerTypeDetector> serverTypeDetectorClass, DatarouterProperties datarouterProperties, Class<? extends DatarouterSettingOverrides> settingOverridesClass, AdditionalSettingRoots additionalSettingRoots, Class<? extends ClientOptionsFactory> clientOptionsFactoryClass, List<Class<? extends Dao>> daoClasses) {
        this.addSettingRoot(DatarouterStorageSettingRoot.class);
        this.serverTypes = serverTypes;
        this.serverTypeDetectorClass = serverTypeDetectorClass;
        this.datarouterProperties = datarouterProperties;
        this.settingOverridesClass = settingOverridesClass;
        this.additionalSettingRoots = additionalSettingRoots;
        this.clientOptionsFactoryClass = clientOptionsFactoryClass;
        this.daoClasses = daoClasses;
    }

    @Override
    public String getName() {
        return "DatarouterStorage";
    }

    public void configure() {
        this.bind(ServerTypes.class).toInstance((Object)this.serverTypes);
        this.bindActual(ServerTypeDetector.class, this.serverTypeDetectorClass);
        this.bindActualInstance(DatarouterProperties.class, this.datarouterProperties);
        if (this.settingOverridesClass != null) {
            this.bind(this.settingOverridesClass).asEagerSingleton();
        }
        if (this.additionalSettingRoots != null) {
            this.bindActualInstance(AdditionalSettingRootsSupplier.class, this.additionalSettingRoots);
        }
        if (this.clientOptionsFactoryClass != null) {
            this.bindActual(ClientOptionsFactory.class, this.clientOptionsFactoryClass);
        }
        this.bind(DaoClasses.class).toInstance((Object)new DaoClasses(this.daoClasses));
    }

    public static class DatarouterStoragePluginBuilder {
        private final ServerTypes serverTypes;
        private final DatarouterProperties datarouterProperties;
        private Class<? extends ServerTypeDetector> serverTypeDetectorClass = ServerTypeDetector.NoOpServerTypeDetector.class;
        private Class<? extends DatarouterSettingOverrides> settingOverridesClass;
        private AdditionalSettingRoots additionalSettingRoots;
        private Class<? extends ClientOptionsFactory> clientOptionsFactoryClass;
        private List<Class<? extends Dao>> daoClasses = new ArrayList<Class<? extends Dao>>();

        public DatarouterStoragePluginBuilder(ServerTypes serverTypes, DatarouterProperties datarouterProperties) {
            this.serverTypes = serverTypes;
            this.datarouterProperties = datarouterProperties;
        }

        public DatarouterStoragePluginBuilder setServerTypeDetector(Class<? extends ServerTypeDetector> serveTypeDetectorClass) {
            this.serverTypeDetectorClass = serveTypeDetectorClass;
            return this;
        }

        public DatarouterStoragePluginBuilder setSettingOverridesClass(Class<? extends DatarouterSettingOverrides> settingOverridesClass) {
            this.settingOverridesClass = settingOverridesClass;
            return this;
        }

        public DatarouterStoragePluginBuilder setAdditionalSettingRootsClass(AdditionalSettingRoots additionalSettingRoots) {
            this.additionalSettingRoots = additionalSettingRoots;
            return this;
        }

        public DatarouterStoragePluginBuilder setClientOptionsFactoryClass(Class<? extends ClientOptionsFactory> clientOptionsFactoryClass) {
            this.clientOptionsFactoryClass = clientOptionsFactoryClass;
            return this;
        }

        public DatarouterStoragePluginBuilder addDao(Class<? extends Dao> dao) {
            this.daoClasses.add(dao);
            return this;
        }

        public DatarouterStoragePluginBuilder addDaosClasses(List<Class<? extends Dao>> daos) {
            this.daoClasses.addAll(daos);
            return this;
        }

        public DatarouterStoragePlugin getSimplePluginData() {
            return new DatarouterStoragePlugin();
        }

        public DatarouterStoragePlugin build() {
            return new DatarouterStoragePlugin(this.serverTypes, this.serverTypeDetectorClass, this.datarouterProperties, this.settingOverridesClass, this.additionalSettingRoots, this.clientOptionsFactoryClass, this.daoClasses);
        }
    }
}

