/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.config.schema;

import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.util.BooleanTool;
import io.datarouter.util.properties.PropertiesTool;
import io.datarouter.util.string.StringTool;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SchemaUpdateOptions {
    private static final Logger logger = LoggerFactory.getLogger(SchemaUpdateOptions.class);
    private static final String SCHEMA_UPDATE_FILENAME = "schema-update.properties";
    private static final String SCHEMA_UPDATE = "schemaUpdate";
    private static final String SCHEMA_UPDATE_ENABLE = "schemaUpdate.enable";
    private static final String PRINT_PREFIX = "schemaUpdate.print";
    private static final String EXECUTE_PREFIX = "schemaUpdate.execute";
    private static final String SUFFIX_createDatabases = ".createDatabases";
    private static final String SUFFIX_createTables = ".createTables";
    private static final String SUFFIX_addColumns = ".addColumns";
    private static final String SUFFIX_deleteColumns = ".deleteColumns";
    private static final String SUFFIX_modifyColumns = ".modifyColumns";
    private static final String SUFFIX_addIndexes = ".addIndexes";
    private static final String SUFFIX_dropIndexes = ".dropIndexes";
    private static final String SUFFIX_modifyEngine = ".modifyEngine";
    private static final String SUFFIX_ignoreClients = ".ignoreClients";
    private static final String SUFFIX_ignoreTables = ".ignoreTables";
    private static final String SUFFIX_modifyRowFormat = ".modifyRowFormat";
    private static final String SUFFIX_modifyCharacterSetOrCollation = ".modifyCharacterSetOrCollation";
    private static final String SUFFIX_modifyTtl = ".modifyTtl";
    private static final String SUFFIX_modifyMaxVersions = ".modifyMaxVersions";
    private final List<String> ignoreClients;
    private final List<String> ignoreTables;
    private Properties properties;

    @Inject
    public SchemaUpdateOptions(DatarouterProperties datarouterProperties) {
        String configFileLocation = datarouterProperties.findConfigFile(SCHEMA_UPDATE_FILENAME);
        try {
            this.properties = PropertiesTool.parse((String)configFileLocation);
        }
        catch (Exception e) {
            logger.warn("error parsing {}, using default schema-update options", (Object)configFileLocation, (Object)e);
            this.properties = new Properties();
        }
        String clientsToIgnore = this.properties.getProperty("schemaUpdate.ignoreClients");
        this.ignoreClients = StringTool.splitOnCharNoRegex((String)clientsToIgnore, (char)',');
        String tablesToIgnore = this.properties.getProperty("schemaUpdate.ignoreTables");
        this.ignoreTables = StringTool.splitOnCharNoRegex((String)tablesToIgnore, (char)',');
    }

    private Optional<Boolean> isPropertyTrue(boolean printVsExecute, String suffix) {
        return this.isPropertyTrue(String.valueOf(SchemaUpdateOptions.choosePrefix(printVsExecute)) + suffix);
    }

    private Optional<Boolean> isPropertyTrue(String property) {
        return Optional.ofNullable(this.properties.getProperty(property)).map(BooleanTool::isTrue);
    }

    private static String choosePrefix(boolean printVsExecute) {
        return printVsExecute ? PRINT_PREFIX : EXECUTE_PREFIX;
    }

    public boolean getEnabled() {
        return this.isPropertyTrue(SCHEMA_UPDATE_ENABLE).orElse(false);
    }

    public Boolean getCreateDatabases(boolean printVsExecute) {
        return this.isPropertyTrue(printVsExecute, SUFFIX_createDatabases).orElse(true);
    }

    public Boolean getCreateTables(boolean printVsExecute) {
        return this.isPropertyTrue(printVsExecute, SUFFIX_createTables).orElse(true);
    }

    public Boolean getAddColumns(boolean printVsExecute) {
        return this.isPropertyTrue(printVsExecute, SUFFIX_addColumns).orElse(printVsExecute);
    }

    public Boolean getDeleteColumns(boolean printVsExecute) {
        return this.isPropertyTrue(printVsExecute, SUFFIX_deleteColumns).orElse(printVsExecute);
    }

    public Boolean getModifyColumns(boolean printVsExecute) {
        return this.isPropertyTrue(printVsExecute, SUFFIX_modifyColumns).orElse(printVsExecute);
    }

    public Boolean getAddIndexes(boolean printVsExecute) {
        return this.isPropertyTrue(printVsExecute, SUFFIX_addIndexes).orElse(printVsExecute);
    }

    public Boolean getDropIndexes(boolean printVsExecute) {
        return this.isPropertyTrue(printVsExecute, SUFFIX_dropIndexes).orElse(printVsExecute);
    }

    public Boolean getModifyEngine(boolean printVsExecute) {
        return this.isPropertyTrue(printVsExecute, SUFFIX_modifyEngine).orElse(printVsExecute);
    }

    public boolean getModifyCharacterSetOrCollation(boolean printVsExecute) {
        return this.isPropertyTrue(printVsExecute, SUFFIX_modifyCharacterSetOrCollation).orElse(printVsExecute);
    }

    public boolean getModifyRowFormat(boolean printVsExecute) {
        return this.isPropertyTrue(printVsExecute, SUFFIX_modifyRowFormat).orElse(printVsExecute);
    }

    public boolean getModifyTtl(boolean printVsExecute) {
        return this.isPropertyTrue(printVsExecute, SUFFIX_modifyTtl).orElse(printVsExecute);
    }

    public boolean getModifyMaxVersions(boolean printVsExecute) {
        return this.isPropertyTrue(printVsExecute, SUFFIX_modifyMaxVersions).orElse(printVsExecute);
    }

    public boolean getModifyPrimaryKey(boolean printVsExecute) {
        return this.getAddIndexes(printVsExecute) != false && this.getDropIndexes(printVsExecute) != false;
    }

    public List<String> getIgnoreClients() {
        return this.ignoreClients;
    }

    public List<String> getIgnoreTables() {
        return this.ignoreTables;
    }
}

