/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.config.stream;

import io.datarouter.storage.config.stream.DatarouterStreamSubscriberAccessor;
import io.datarouter.storage.config.stream.DatarouterStreamSubscriberAccessorSetter;
import io.datarouter.storage.config.stream.DrInitialPositionInStream;
import java.util.Date;

public class DatarouterStreamSubscriberConfig
implements DatarouterStreamSubscriberAccessorSetter {
    private final Integer blockingQueueSize;
    private final Integer maxRecordsPerRequest;
    private Integer initialLeaseTableReadCapacity;
    private Integer initialLeaseTableWriteCapacity;
    private DrInitialPositionInStream drInitialPositionInStream = DrInitialPositionInStream.LATEST;
    private DatarouterStreamSubscriberAccessor subscriberAccessor;
    private Date timestamp;
    private String subscriberAppName;
    private boolean replayData = false;

    public DatarouterStreamSubscriberConfig(Integer blockingQueueSize, Integer maxRecordsPerRequest) {
        this.blockingQueueSize = blockingQueueSize;
        this.maxRecordsPerRequest = maxRecordsPerRequest;
    }

    @Override
    public void setDatarouterStreamSubscriberAccessor(DatarouterStreamSubscriberAccessor subscriberAccessor) {
        this.subscriberAccessor = subscriberAccessor;
    }

    public DatarouterStreamSubscriberConfig withInitialPositionInStream(DrInitialPositionInStream initialPositionInStream) {
        this.drInitialPositionInStream = initialPositionInStream;
        return this;
    }

    public DatarouterStreamSubscriberConfig withTimestampAtInitialPositionInStreamAtTimestamp(Date timestamp) {
        this.timestamp = timestamp;
        this.drInitialPositionInStream = DrInitialPositionInStream.AT_TIMESTAMP;
        return this;
    }

    public DatarouterStreamSubscriberConfig withExplicitSubscriberAppName(String subscriberAppName) {
        this.subscriberAppName = subscriberAppName;
        return this;
    }

    public DatarouterStreamSubscriberConfig withReplayData(boolean replayData) {
        this.replayData = replayData;
        return this;
    }

    public DatarouterStreamSubscriberConfig withInitialLeaseTableReadCapacity(Integer initialLeaseTableReadCapacity) {
        this.initialLeaseTableReadCapacity = initialLeaseTableReadCapacity;
        return this;
    }

    public DatarouterStreamSubscriberConfig withInitialLeaseTableWriteCapacity(Integer initialLeaseTableWriteCapacity) {
        this.initialLeaseTableWriteCapacity = initialLeaseTableWriteCapacity;
        return this;
    }

    public DatarouterStreamSubscriberAccessor getSubscriberAccessor() {
        return this.subscriberAccessor;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public int getBlockingQueueSize() {
        return this.blockingQueueSize;
    }

    public Integer getMaxRecordsPerRequest() {
        return this.maxRecordsPerRequest;
    }

    public String getSubscriberAppName() {
        return this.subscriberAppName;
    }

    public DrInitialPositionInStream getDrInitialPositionInStream() {
        return this.drInitialPositionInStream;
    }

    public boolean getReplayData() {
        return this.replayData;
    }

    public Integer getInitialLeaseTableReadCapacity() {
        return this.initialLeaseTableReadCapacity;
    }

    public Integer getInitialLeaseTableWriteCapacity() {
        return this.initialLeaseTableWriteCapacity;
    }
}

