/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.adapter.callsite.mixin;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.index.IndexEntry;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.key.unique.UniqueKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.adapter.callsite.CallsiteAdapter;
import io.datarouter.storage.node.op.raw.IndexedStorage;
import io.datarouter.storage.node.type.index.ManagedNode;
import io.datarouter.storage.serialize.fieldcache.IndexEntryFieldInfo;
import io.datarouter.util.lang.LineOfCode;
import io.datarouter.util.tuple.Range;
import java.util.Collection;
import java.util.List;

public interface IndexedStorageCallsiteAdapterMixin<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends IndexedStorage.IndexedStorageNode<PK, D, F>>
extends IndexedStorage<PK, D>,
CallsiteAdapter {
    public N getBackingNode();

    @Override
    default public void deleteUnique(UniqueKey<PK> uniqueKey, Config config) {
        LineOfCode lineOfCode = this.getCallsite();
        long startNs = System.nanoTime();
        try {
            this.getBackingNode().deleteUnique(uniqueKey, config);
        }
        finally {
            this.recordCallsite(lineOfCode, startNs, 1);
        }
    }

    @Override
    default public void deleteMultiUnique(Collection<? extends UniqueKey<PK>> uniqueKeys, Config config) {
        LineOfCode lineOfCode = this.getCallsite();
        long startNs = System.nanoTime();
        try {
            this.getBackingNode().deleteMultiUnique(uniqueKeys, config);
        }
        finally {
            this.recordCollectionCallsite(lineOfCode, startNs, uniqueKeys);
        }
    }

    @Override
    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>> void deleteByIndex(Collection<IK> keys, Config config, IndexEntryFieldInfo<IK, IE, IF> indexEntryFieldInfo) {
        LineOfCode lineOfCode = this.getCallsite();
        long startNs = System.nanoTime();
        try {
            this.getBackingNode().deleteByIndex(keys, config, indexEntryFieldInfo);
        }
        finally {
            this.recordCollectionCallsite(lineOfCode, startNs, keys);
        }
    }

    @Override
    default public D lookupUnique(UniqueKey<PK> uniqueKey, Config config) {
        int numResults;
        D d;
        LineOfCode lineOfCode = this.getCallsite();
        long startNs = System.nanoTime();
        D result = null;
        try {
            d = result = (D)this.getBackingNode().lookupUnique(uniqueKey, config);
            numResults = result == null ? 0 : 1;
        }
        catch (Throwable throwable) {
            int numResults2 = result == null ? 0 : 1;
            this.recordCallsite(lineOfCode, startNs, numResults2);
            throw throwable;
        }
        this.recordCallsite(lineOfCode, startNs, numResults);
        return d;
    }

    @Override
    default public List<D> lookupMultiUnique(Collection<? extends UniqueKey<PK>> uniqueKeys, Config config) {
        LineOfCode lineOfCode = this.getCallsite();
        long startNs = System.nanoTime();
        List results = null;
        try {
            List list = results = this.getBackingNode().lookupMultiUnique(uniqueKeys, config);
            return list;
        }
        finally {
            this.recordCollectionCallsite(lineOfCode, startNs, results);
        }
    }

    @Override
    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>> List<IE> getMultiFromIndex(Collection<IK> keys, Config config, IndexEntryFieldInfo<IK, IE, IF> indexEntryFieldInfo) {
        LineOfCode lineOfCode = this.getCallsite();
        long startNs = System.nanoTime();
        try {
            List<IE> list = this.getBackingNode().getMultiFromIndex(keys, config, indexEntryFieldInfo);
            return list;
        }
        finally {
            this.recordCollectionCallsite(lineOfCode, startNs, keys);
        }
    }

    @Override
    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>> List<D> getMultiByIndex(Collection<IK> keys, Config config, IndexEntryFieldInfo<IK, IE, IF> indexEntryFieldInfo) {
        LineOfCode lineOfCode = this.getCallsite();
        long startNs = System.nanoTime();
        try {
            List list = this.getBackingNode().getMultiByIndex(keys, config, indexEntryFieldInfo);
            return list;
        }
        finally {
            this.recordCollectionCallsite(lineOfCode, startNs, keys);
        }
    }

    @Override
    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>> Scanner<IE> scanMultiIndex(IndexEntryFieldInfo<IK, IE, IF> indexEntryFieldInfo, Collection<Range<IK>> ranges, Config config) {
        LineOfCode lineOfCode = this.getCallsite();
        long startNs = System.nanoTime();
        try {
            Scanner<IE> scanner = this.getBackingNode().scanMultiIndex(indexEntryFieldInfo, ranges, config);
            return scanner;
        }
        finally {
            this.recordCallsite(lineOfCode, startNs, 1);
        }
    }

    @Override
    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>> Scanner<D> scanMultiByIndex(IndexEntryFieldInfo<IK, IE, IF> indexEntryFieldInfo, Collection<Range<IK>> ranges, Config config) {
        LineOfCode lineOfCode = this.getCallsite();
        long startNs = System.nanoTime();
        try {
            Scanner scanner = this.getBackingNode().scanMultiByIndex(indexEntryFieldInfo, ranges, config);
            return scanner;
        }
        finally {
            this.recordCallsite(lineOfCode, startNs, 1);
        }
    }

    @Override
    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>> Scanner<IK> scanMultiIndexKeys(IndexEntryFieldInfo<IK, IE, IF> indexEntryFieldInfo, Collection<Range<IK>> ranges, Config config) {
        LineOfCode lineOfCode = this.getCallsite();
        long startNs = System.nanoTime();
        try {
            Scanner<IK> scanner = this.getBackingNode().scanMultiIndexKeys(indexEntryFieldInfo, ranges, config);
            return scanner;
        }
        finally {
            this.recordCallsite(lineOfCode, startNs, 1);
        }
    }

    @Override
    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>, MN extends ManagedNode<PK, D, IK, IE, IF>> MN registerManaged(MN managedNode) {
        return this.getBackingNode().registerManaged(managedNode);
    }

    @Override
    default public List<ManagedNode<PK, D, ?, ?, ?>> getManagedNodes() {
        return this.getBackingNode().getManagedNodes();
    }
}

