/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.adapter.counter.mixin;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.adapter.counter.mixin.MapStorageReaderCounterAdapterMixin;
import io.datarouter.storage.node.op.raw.MapStorage;
import io.datarouter.util.collection.CollectionTool;
import java.util.Collection;

public interface MapStorageCounterAdapterMixin<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends MapStorage.MapStorageNode<PK, D, F>>
extends MapStorage<PK, D>,
MapStorageReaderCounterAdapterMixin<PK, D, F, N> {
    @Override
    default public void put(D databean, Config config) {
        String opName = "put";
        this.getCounter().count(opName);
        ((MapStorage.MapStorageNode)this.getBackingNode()).put(databean, config);
    }

    @Override
    default public void putMulti(Collection<D> databeans, Config config) {
        String opName = "putMulti";
        this.getCounter().count(opName);
        this.getCounter().count(String.valueOf(opName) + " databeans", CollectionTool.size(databeans));
        ((MapStorage.MapStorageNode)this.getBackingNode()).putMulti(databeans, config);
    }

    @Override
    default public void delete(PK key, Config config) {
        String opName = "delete";
        this.getCounter().count(opName);
        ((MapStorage.MapStorageNode)this.getBackingNode()).delete(key, config);
    }

    @Override
    default public void deleteMulti(Collection<PK> keys, Config config) {
        String opName = "deleteMulti";
        this.getCounter().count(opName);
        this.getCounter().count(String.valueOf(opName) + " keys", CollectionTool.size(keys));
        ((MapStorage.MapStorageNode)this.getBackingNode()).deleteMulti(keys, config);
    }

    @Override
    default public void deleteAll(Config config) {
        String opName = "deleteAll";
        this.getCounter().count(opName);
        ((MapStorage.MapStorageNode)this.getBackingNode()).deleteAll(config);
    }
}

