/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.adapter.counter.mixin;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.adapter.counter.CounterAdapter;
import io.datarouter.storage.node.op.raw.read.MapStorageReader;
import io.datarouter.util.collection.CollectionTool;
import java.util.Collection;
import java.util.List;

public interface MapStorageReaderCounterAdapterMixin<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends MapStorageReader.MapStorageReaderNode<PK, D, F>>
extends MapStorageReader<PK, D>,
CounterAdapter<PK, D, F, N> {
    @Override
    default public boolean exists(PK key, Config config) {
        String opName = "exists";
        this.getCounter().count(opName);
        boolean result = ((MapStorageReader.MapStorageReaderNode)this.getBackingNode()).exists(key, config);
        String hitOrMiss = result ? "hit" : "miss";
        this.getCounter().count(String.valueOf(opName) + " " + hitOrMiss);
        return result;
    }

    @Override
    default public D get(PK key, Config config) {
        String opName = "get";
        this.getCounter().count(opName);
        Object result = ((MapStorageReader.MapStorageReaderNode)this.getBackingNode()).get(key, config);
        String hitOrMiss = result != null ? "hit" : "miss";
        this.getCounter().count(String.valueOf(opName) + " " + hitOrMiss);
        return result;
    }

    @Override
    default public List<D> getMulti(Collection<PK> keys, Config config) {
        String opName = "getMulti";
        this.getCounter().count(opName);
        this.getCounter().count(String.valueOf(opName) + " keys", CollectionTool.size(keys));
        List results = ((MapStorageReader.MapStorageReaderNode)this.getBackingNode()).getMulti(keys, config);
        int numHits = CollectionTool.size(results);
        int numMisses = CollectionTool.size(keys) - numHits;
        this.getCounter().count(String.valueOf(opName) + " hit", numHits);
        this.getCounter().count(String.valueOf(opName) + " miss", numMisses);
        return results;
    }

    @Override
    default public List<PK> getKeys(Collection<PK> keys, Config config) {
        String opName = "getKeys";
        this.getCounter().count(opName);
        this.getCounter().count(String.valueOf(opName) + " keys", CollectionTool.size(keys));
        List<PK> results = ((MapStorageReader.MapStorageReaderNode)this.getBackingNode()).getKeys(keys, config);
        int numHits = CollectionTool.size(results);
        int numMisses = CollectionTool.size(keys) - numHits;
        this.getCounter().count(String.valueOf(opName) + " hit", numHits);
        this.getCounter().count(String.valueOf(opName) + " miss", numMisses);
        return results;
    }
}

