/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.adapter.sanitization.mixin;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.adapter.sanitization.mixin.MapStorageReaderSanitizationAdapterMixin;
import io.datarouter.storage.node.adapter.sanitization.sanitizer.PrimaryKeySanitizer;
import io.datarouter.storage.node.op.raw.MapStorage;
import java.util.Collection;

public interface MapStorageSanitizationAdapterMixin<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends MapStorage.MapStorageNode<PK, D, F>>
extends MapStorage<PK, D>,
MapStorageReaderSanitizationAdapterMixin<PK, D, F, N> {
    @Override
    default public void put(D databean, Config config) {
        if (databean != null) {
            PrimaryKeySanitizer.checkForNullPrimaryKeyValues(databean.getKey());
        }
        ((MapStorage.MapStorageNode)this.getBackingNode()).put(databean, config);
    }

    @Override
    default public void putMulti(Collection<D> databeans, Config config) {
        databeans.stream().map(Databean::getKey).forEach(PrimaryKeySanitizer::checkForNullPrimaryKeyValues);
        ((MapStorage.MapStorageNode)this.getBackingNode()).putMulti(databeans, config);
    }

    @Override
    default public void delete(PK key, Config config) {
        ((MapStorage.MapStorageNode)this.getBackingNode()).delete(key, config);
    }

    @Override
    default public void deleteMulti(Collection<PK> keys, Config config) {
        ((MapStorage.MapStorageNode)this.getBackingNode()).deleteMulti(keys, config);
    }

    @Override
    default public void deleteAll(Config config) {
        ((MapStorage.MapStorageNode)this.getBackingNode()).deleteAll(config);
    }
}

