/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.adapter.trace.mixin;

import io.datarouter.instrumentation.trace.TraceSpanFinisher;
import io.datarouter.instrumentation.trace.TracerTool;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.index.IndexEntry;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.key.unique.UniqueKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.adapter.trace.TraceAdapter;
import io.datarouter.storage.node.op.raw.IndexedStorage;
import io.datarouter.storage.node.type.index.ManagedNode;
import io.datarouter.storage.serialize.fieldcache.IndexEntryFieldInfo;
import io.datarouter.util.tuple.Range;
import java.util.Collection;
import java.util.List;

public interface IndexedStorageTraceAdapterMixin<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends IndexedStorage.IndexedStorageNode<PK, D, F>>
extends IndexedStorage<PK, D>,
TraceAdapter<PK, D, F, N> {
    @Override
    default public D lookupUnique(UniqueKey<PK> uniqueKey, Config config) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TraceSpanFinisher finisher = this.startSpanForOp("lookupUnique");){
            Object result = ((IndexedStorage.IndexedStorageNode)this.getBackingNode()).lookupUnique(uniqueKey, config);
            TracerTool.appendToSpanInfo((String)(result != null ? "hit" : "miss"));
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    default public List<D> lookupMultiUnique(Collection<? extends UniqueKey<PK>> uniqueKeys, Config config) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TraceSpanFinisher finisher = this.startSpanForOp("lookupMultiUnique");){
            List results = ((IndexedStorage.IndexedStorageNode)this.getBackingNode()).lookupMultiUnique(uniqueKeys, config);
            TracerTool.appendToSpanInfo((String)String.format("got %d/%d", results.size(), uniqueKeys.size()));
            return results;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>> List<IE> getMultiFromIndex(Collection<IK> keys, Config config, IndexEntryFieldInfo<IK, IE, IF> indexEntryFieldInfo) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TraceSpanFinisher finisher = this.startSpanForOp("getFromIndex");){
            List<IE> results = ((IndexedStorage.IndexedStorageNode)this.getBackingNode()).getMultiFromIndex(keys, config, indexEntryFieldInfo);
            TracerTool.appendToSpanInfo((String)String.format("got %d/%d", results.size(), keys.size()));
            return results;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>> List<D> getMultiByIndex(Collection<IK> keys, Config config, IndexEntryFieldInfo<IK, IE, IF> indexEntryFieldInfo) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TraceSpanFinisher finisher = this.startSpanForOp("getFromIndex");){
            List results = ((IndexedStorage.IndexedStorageNode)this.getBackingNode()).getMultiByIndex(keys, config, indexEntryFieldInfo);
            TracerTool.appendToSpanInfo((String)String.format("got %d/%d", results.size(), keys.size()));
            return results;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>> Scanner<IE> scanMultiIndex(IndexEntryFieldInfo<IK, IE, IF> indexEntryFieldInfo, Collection<Range<IK>> ranges, Config config) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TraceSpanFinisher finisher = this.startSpanForOp("scanIndex");){
            TracerTool.appendToSpanInfo((TracerTool.TraceSpanInfoBuilder)new TracerTool.TraceSpanInfoBuilder().ranges((Number)ranges.size()));
            return ((IndexedStorage.IndexedStorageNode)this.getBackingNode()).scanMultiIndex(indexEntryFieldInfo, ranges, config);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>> Scanner<D> scanMultiByIndex(IndexEntryFieldInfo<IK, IE, IF> indexEntryFieldInfo, Collection<Range<IK>> ranges, Config config) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TraceSpanFinisher finisher = this.startSpanForOp("scanByIndex");){
            TracerTool.appendToSpanInfo((TracerTool.TraceSpanInfoBuilder)new TracerTool.TraceSpanInfoBuilder().ranges((Number)ranges.size()));
            return ((IndexedStorage.IndexedStorageNode)this.getBackingNode()).scanMultiByIndex(indexEntryFieldInfo, ranges, config);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>> Scanner<IK> scanMultiIndexKeys(IndexEntryFieldInfo<IK, IE, IF> indexEntryFieldInfo, Collection<Range<IK>> ranges, Config config) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TraceSpanFinisher finisher = this.startSpanForOp("scanIndexKeys");){
            TracerTool.appendToSpanInfo((TracerTool.TraceSpanInfoBuilder)new TracerTool.TraceSpanInfoBuilder().ranges((Number)ranges.size()));
            return ((IndexedStorage.IndexedStorageNode)this.getBackingNode()).scanMultiIndexKeys(indexEntryFieldInfo, ranges, config);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    default public void deleteUnique(UniqueKey<PK> uniqueKey, Config config) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TraceSpanFinisher finisher = this.startSpanForOp("deleteUnique");){
            ((IndexedStorage.IndexedStorageNode)this.getBackingNode()).deleteUnique(uniqueKey, config);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    default public void deleteMultiUnique(Collection<? extends UniqueKey<PK>> uniqueKeys, Config config) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TraceSpanFinisher finisher = this.startSpanForOp("deleteMultiUnique");){
            TracerTool.appendToSpanInfo((TracerTool.TraceSpanInfoBuilder)new TracerTool.TraceSpanInfoBuilder().keys((Number)uniqueKeys.size()));
            ((IndexedStorage.IndexedStorageNode)this.getBackingNode()).deleteMultiUnique(uniqueKeys, config);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>> void deleteByIndex(Collection<IK> keys, Config config, IndexEntryFieldInfo<IK, IE, IF> indexEntryFieldInfo) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TraceSpanFinisher finisher = this.startSpanForOp("deleteByIndex");){
            TracerTool.appendToSpanInfo((TracerTool.TraceSpanInfoBuilder)new TracerTool.TraceSpanInfoBuilder().keys((Number)keys.size()));
            ((IndexedStorage.IndexedStorageNode)this.getBackingNode()).deleteByIndex(keys, config, indexEntryFieldInfo);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>, MN extends ManagedNode<PK, D, IK, IE, IF>> MN registerManaged(MN managedNode) {
        return ((IndexedStorage.IndexedStorageNode)this.getBackingNode()).registerManaged(managedNode);
    }

    @Override
    default public List<ManagedNode<PK, D, ?, ?, ?>> getManagedNodes() {
        return ((IndexedStorage.IndexedStorageNode)this.getBackingNode()).getManagedNodes();
    }
}

