/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.factory;

import io.datarouter.inject.DatarouterInjector;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.entity.Entity;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.key.primary.RegularPrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientNodeFactory;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.client.DatarouterClients;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.builder.NodeBuilder;
import io.datarouter.storage.node.entity.EntityNodeParams;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import io.datarouter.util.lang.ReflectionTool;
import java.util.function.Supplier;

public abstract class BaseNodeFactory {
    private final Datarouter datarouter;
    private final DatarouterClients clients;
    private final DatarouterInjector injector;
    private final Supplier<Boolean> enableDiagnosticsSupplier;

    public BaseNodeFactory(Datarouter datarouter, DatarouterClients clients, DatarouterInjector injector, Supplier<Boolean> enableDiagnosticsSupplier) {
        this.datarouter = datarouter;
        this.clients = clients;
        this.injector = injector;
        this.enableDiagnosticsSupplier = enableDiagnosticsSupplier;
    }

    public <EK extends EntityKey<EK>, E extends Entity<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends PhysicalNode<PK, D, F>> N create(EntityNodeParams<EK, E> entityNodeParams, NodeParams<PK, D, F> params) {
        ClientType<?, ?> clientType = this.getClientTypeInstance(params.getClientId());
        ClientNodeFactory clientNodeFactory = this.getClientFactories(clientType);
        return (N)((PhysicalNode)BaseNodeFactory.cast(clientNodeFactory.createWrappedNode(entityNodeParams, params)));
    }

    public <EK extends EntityKey<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> NodeBuilder<EK, PK, D, F> create(ClientId clientId, Supplier<EK> entityKeySupplier, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier) {
        return new NodeBuilder(this, this.enableDiagnosticsSupplier, clientId, entityKeySupplier, databeanSupplier, fielderSupplier);
    }

    public <PK extends RegularPrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> NodeBuilder<PK, PK, D, F> create(ClientId clientId, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier) {
        Supplier<RegularPrimaryKey> entityKeySupplier = () -> (RegularPrimaryKey)ReflectionTool.create((Class)((Databean)databeanSupplier.get()).getKeyClass());
        return this.create(clientId, entityKeySupplier, databeanSupplier, fielderSupplier);
    }

    public <EK extends EntityKey<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends PhysicalNode<PK, D, F>> N register(N node) {
        return this.datarouter.register(node);
    }

    private ClientType<?, ?> getClientTypeInstance(ClientId clientId) {
        return this.clients.getClientTypeInstance(clientId);
    }

    private ClientNodeFactory getClientFactories(ClientType<?, ?> clientType) {
        return (ClientNodeFactory)this.injector.getInstance(clientType.getClientNodeFactoryClass());
    }

    public static <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends Node<PK, D, F>> N cast(Node<PK, D, F> node) {
        return (N)node;
    }
}

