/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.factory;

import io.datarouter.inject.DatarouterInjector;
import io.datarouter.model.entity.Entity;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientNodeFactory;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.client.DatarouterClients;
import io.datarouter.storage.node.entity.EntityNode;
import io.datarouter.storage.node.entity.EntityNodeParams;
import io.datarouter.storage.node.factory.NodeFactory;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class EntityNodeFactory {
    @Inject
    private DatarouterClients clients;
    @Inject
    private NodeFactory nodeFactory;
    @Inject
    private DatarouterInjector injector;

    public <EK extends EntityKey<EK>, E extends Entity<EK>> EntityNode<EK, E> create(ClientId clientId, EntityNodeParams<EK, E> params) {
        ClientType<?, ?> clientType = this.clients.getClientTypeInstance(clientId);
        Objects.requireNonNull(clientType, "clientType not found for clientId:" + clientId);
        ClientNodeFactory clientNodeFactory = (ClientNodeFactory)this.injector.getInstance(clientType.getClientNodeFactoryClass());
        EntityNode<EK, E> entityNode = clientNodeFactory.createEntityNode(this.nodeFactory, params, clientId);
        return entityNode;
    }
}

