/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.op.raw.read;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.op.NodeOps;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public interface MapStorageReader<PK extends PrimaryKey<PK>, D extends Databean<PK, D>>
extends NodeOps<PK, D> {
    public static final String OP_exists = "exists";
    public static final String OP_get = "get";
    public static final String OP_getMulti = "getMulti";
    public static final String OP_getKeys = "getKeys";

    public boolean exists(PK var1, Config var2);

    default public boolean exists(PK key) {
        return this.exists(key, new Config());
    }

    public List<PK> getKeys(Collection<PK> var1, Config var2);

    default public List<PK> getKeys(Collection<PK> keys) {
        return this.getKeys(keys, new Config());
    }

    public D get(PK var1, Config var2);

    default public D get(PK key) {
        return this.get(key, new Config());
    }

    public List<D> getMulti(Collection<PK> var1, Config var2);

    default public List<D> getMulti(Collection<PK> keys) {
        return this.getMulti(keys, new Config());
    }

    default public Optional<D> find(PK key, Config config) {
        return Optional.ofNullable(this.get(key, config));
    }

    default public Optional<D> find(PK key) {
        return this.find(key, new Config());
    }

    public static interface MapStorageReaderNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
    extends Node<PK, D, F>,
    MapStorageReader<PK, D> {
    }

    public static interface PhysicalMapStorageReaderNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
    extends PhysicalNode<PK, D, F>,
    MapStorageReaderNode<PK, D, F> {
    }
}

