/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.op.raw.read;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.op.NodeOps;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import io.datarouter.storage.op.scan.SortedStorageSamplingScanner;
import io.datarouter.storage.util.KeyRangeTool;
import io.datarouter.util.tuple.Range;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public interface SortedStorageReader<PK extends PrimaryKey<PK>, D extends Databean<PK, D>>
extends NodeOps<PK, D> {
    public static final String OP_getKeysInRange = "getKeysInRange";
    public static final String OP_getRange = "getRange";
    public static final String OP_getPrefixedRange = "getPrefixedRange";
    public static final String OP_scanKeys = "scanKeys";
    public static final String OP_scanKeysMulti = "scanKeysMulti";
    public static final String OP_scan = "scan";
    public static final String OP_scanMulti = "scanMulti";

    public Scanner<D> scanMulti(Collection<Range<PK>> var1, Config var2);

    default public Scanner<D> scanMulti(Collection<Range<PK>> ranges) {
        return this.scanMulti(ranges, new Config());
    }

    default public Scanner<D> scan(Range<PK> range, Config config) {
        return this.scanMulti(Collections.singletonList(range), config);
    }

    default public Scanner<D> scan(Range<PK> range) {
        return this.scan(range, new Config());
    }

    default public Scanner<D> scan(Config config) {
        return this.scan(Range.everything(), config);
    }

    default public Scanner<D> scan() {
        return this.scan(Range.everything(), new Config());
    }

    public Scanner<PK> scanKeysMulti(Collection<Range<PK>> var1, Config var2);

    default public Scanner<PK> scanKeysMulti(Collection<Range<PK>> ranges) {
        return this.scanKeysMulti(ranges, new Config());
    }

    default public Scanner<PK> scanKeys(Range<PK> range, Config config) {
        return this.scanKeysMulti(Collections.singletonList(range), config);
    }

    default public Scanner<PK> scanKeys(Range<PK> range) {
        return this.scanKeys(range, new Config());
    }

    default public Scanner<PK> scanKeys(Config config) {
        return this.scanKeys(Range.everything(), config);
    }

    default public Scanner<PK> scanKeys() {
        return this.scanKeys(Range.everything(), new Config());
    }

    default public Scanner<D> scanWithPrefix(PK prefix, Config config) {
        return this.scan(KeyRangeTool.forPrefix(prefix), config);
    }

    default public Scanner<D> scanWithPrefix(PK prefix) {
        return this.scanWithPrefix(prefix, new Config());
    }

    default public Scanner<PK> scanKeysWithPrefix(PK prefix, Config config) {
        return this.scanKeys(KeyRangeTool.forPrefix(prefix), config);
    }

    default public Scanner<PK> scanKeysWithPrefix(PK prefix) {
        return this.scanKeysWithPrefix(prefix, new Config());
    }

    default public Scanner<D> scanWithPrefixes(Collection<PK> prefixes, Config config) {
        return this.scanMulti(SortedStorageReader.getRangesFromPrefixes(prefixes), config);
    }

    default public Scanner<D> scanWithPrefixes(Collection<PK> prefixes) {
        return this.scanWithPrefixes(prefixes, new Config());
    }

    default public Scanner<PK> scanKeysWithPrefixes(Collection<PK> prefixes, Config config) {
        return this.scanKeysMulti(SortedStorageReader.getRangesFromPrefixes(prefixes), config);
    }

    default public Scanner<PK> scanKeysWithPrefixes(Collection<PK> prefixes) {
        return this.scanKeysWithPrefixes(prefixes, new Config());
    }

    default public long count(Range<PK> range) {
        return new SortedStorageSamplingScanner.SortedStorageSamplingScannerBuilder<PK>(this).withRange(range).build().findLast().map(sample -> sample.totalCount).orElse(0L);
    }

    public static <PK extends PrimaryKey<PK>> List<Range<PK>> getRangesFromPrefixes(Collection<PK> prefixes) {
        return prefixes.stream().map(KeyRangeTool::forPrefix).collect(Collectors.toList());
    }

    public static interface PhysicalSortedStorageReaderNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
    extends PhysicalNode<PK, D, F>,
    SortedStorageReaderNode<PK, D, F> {
    }

    public static interface SortedStorageReaderNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
    extends Node<PK, D, F>,
    SortedStorageReader<PK, D> {
    }
}

