/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.tableconfig;

import io.datarouter.storage.dao.Daos;
import io.datarouter.storage.node.DatarouterNodes;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.tableconfig.ClientTableEntityPrefixNameWrapper;
import io.datarouter.storage.node.tableconfig.NodewatchConfiguration;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import io.datarouter.storage.serialize.fieldcache.PhysicalDatabeanFieldInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TableConfigurationService {
    @Inject
    private Daos daos;
    @Inject
    private DatarouterNodes datarouterNodes;

    public List<NodewatchConfiguration> getTableConfigurations() {
        return this.datarouterNodes.getAllNodes().stream().map(Node::getPhysicalNodes).flatMap(Collection::stream).map(PhysicalNode::getFieldInfo).map(PhysicalDatabeanFieldInfo::getTableConfiguration).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Map<ClientTableEntityPrefixNameWrapper, NodewatchConfiguration> getTableConfigMap() {
        return this.getTableConfigurations().stream().distinct().collect(Collectors.toMap(config -> config.nodeNameWrapper, Function.identity()));
    }
}

