/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.type.index;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.databean.DatabeanTool;
import io.datarouter.model.index.IndexEntry;
import io.datarouter.model.index.KeyIndexEntry;
import io.datarouter.model.index.unique.UniqueKeyIndexEntry;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import io.datarouter.storage.node.op.raw.index.IndexListener;
import io.datarouter.storage.node.type.index.base.BaseIndexNode;
import io.datarouter.util.collection.CollectionTool;
import io.datarouter.util.collection.ListTool;
import io.datarouter.util.iterable.IterableTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;

public class IndexMapStorageWriterListener<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>, IN extends SortedMapStorage.SortedMapStorageNode<IK, IE, IF>>
extends BaseIndexNode<PK, D, IK, IE, IF, IN>
implements IndexListener<PK, D> {
    public IndexMapStorageWriterListener(Supplier<IE> indexEntrySupplier, IN indexNode) {
        super(indexEntrySupplier, indexNode);
    }

    @Override
    public void onDelete(PK key, Config config) {
        if (key == null) {
            throw new IllegalArgumentException("invalid null key");
        }
        Object indexEntryBuilder = this.createIndexEntry();
        if (!(indexEntryBuilder instanceof KeyIndexEntry)) {
            throw new IllegalArgumentException("Unable to find index from PK, please call deleteDatabean method instead");
        }
        IndexEntry indexEntry = (IndexEntry)((UniqueKeyIndexEntry)indexEntryBuilder).fromPrimaryKey(key);
        ((SortedMapStorage.SortedMapStorageNode)this.indexNode).delete(indexEntry.getKey(), config);
    }

    @Override
    public void onDeleteDatabean(D databean, Config config) {
        Object sampleIndexEntry = this.createIndexEntry();
        List indexEntriesFromSingleDatabean = sampleIndexEntry.createFromDatabean(databean);
        ((SortedMapStorage.SortedMapStorageNode)this.indexNode).deleteMulti(DatabeanTool.getKeys((Iterable)indexEntriesFromSingleDatabean), config);
    }

    @Override
    public void onDeleteAll(Config config) {
        ((SortedMapStorage.SortedMapStorageNode)this.indexNode).deleteAll(config);
    }

    @Override
    public void onDeleteMulti(Collection<PK> keys, Config config) {
        if (CollectionTool.nullSafe(keys).contains(null)) {
            throw new IllegalArgumentException("invalid null key");
        }
        List<IE> indexEntries = this.getIndexEntriesFromPrimaryKeys(keys);
        ((SortedMapStorage.SortedMapStorageNode)this.indexNode).deleteMulti(DatabeanTool.getKeys(indexEntries), config);
    }

    @Override
    public void onDeleteMultiDatabeans(Collection<D> databeans, Config config) {
        List<IE> indexEntries = this.getIndexEntriesFromDatabeans(databeans);
        ((SortedMapStorage.SortedMapStorageNode)this.indexNode).deleteMulti(DatabeanTool.getKeys(indexEntries), config);
    }

    @Override
    public void onPut(D databean, Config config) {
        if (databean == null) {
            throw new IllegalArgumentException("invalid null databean");
        }
        Object sampleIndexEntry = this.createIndexEntry();
        List indexEntries = sampleIndexEntry.createFromDatabean(databean);
        ((SortedMapStorage.SortedMapStorageNode)this.indexNode).putMulti(indexEntries, config);
    }

    @Override
    public void onPutMulti(Collection<D> databeans, Config config) {
        if (CollectionTool.nullSafe(databeans).contains(null)) {
            throw new IllegalArgumentException("invalid null databean");
        }
        List<IE> indexEntries = this.getIndexEntriesFromDatabeans(databeans);
        ((SortedMapStorage.SortedMapStorageNode)this.indexNode).putMulti(indexEntries, config);
    }

    private List<IE> getIndexEntriesFromPrimaryKeys(Collection<PK> primaryKeys) {
        ArrayList indexEntries = ListTool.createArrayListWithSize(primaryKeys);
        for (PrimaryKey key : IterableTool.nullSafe(primaryKeys)) {
            Object indexEntryBuilder = this.createIndexEntry();
            if (indexEntryBuilder instanceof UniqueKeyIndexEntry) {
                IndexEntry indexEntry = (IndexEntry)((UniqueKeyIndexEntry)indexEntryBuilder).fromPrimaryKey(key);
                indexEntries.add(indexEntry);
                continue;
            }
            throw new IllegalArgumentException("Unable to find index from PK, please call deleteMultiDatabeans method instead");
        }
        return indexEntries;
    }

    private List<IE> getIndexEntriesFromDatabeans(Collection<D> databeans) {
        Object sampleIndexEntry = this.createIndexEntry();
        ArrayList indexEntries = ListTool.createArrayListWithSize(databeans);
        for (Databean databean : IterableTool.nullSafe(databeans)) {
            List indexEntriesFromSingleDatabean = sampleIndexEntry.createFromDatabean(databean);
            indexEntries.addAll(CollectionTool.nullSafe((Collection)indexEntriesFromSingleDatabean));
        }
        return indexEntries;
    }
}

