/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.type.physical.base;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.node.BaseNode;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import io.datarouter.storage.serialize.fieldcache.PhysicalDatabeanFieldInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public abstract class BasePhysicalNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends BaseNode<PK, D, F>
implements PhysicalNode<PK, D, F> {
    private final ClientType<?, ?> clientType;
    private final PhysicalDatabeanFieldInfo<PK, D, F> fieldInfo;

    public BasePhysicalNode(NodeParams<PK, D, F> params, ClientType<?, ?> clientType) {
        super(params);
        this.clientType = clientType;
        this.fieldInfo = new PhysicalDatabeanFieldInfo<PK, D, F>(params);
    }

    @Override
    public final String getName() {
        return this.fieldInfo.getNodeName();
    }

    @Override
    public List<ClientId> getClientIds() {
        return Collections.singletonList(((PhysicalDatabeanFieldInfo)this.getFieldInfo()).getClientId());
    }

    @Override
    public ClientId getClientId() {
        return ((PhysicalDatabeanFieldInfo)this.getFieldInfo()).getClientId();
    }

    @Override
    public boolean usesClient(String clientName) {
        return Objects.equals(((PhysicalDatabeanFieldInfo)this.getFieldInfo()).getClientId().getName(), clientName);
    }

    @Override
    public List<Node<PK, D, F>> getChildNodes() {
        return new ArrayList<Node<PK, D, F>>();
    }

    @Override
    public List<? extends PhysicalNode<PK, D, F>> getPhysicalNodes() {
        LinkedList<BasePhysicalNode> physicalNodes = new LinkedList<BasePhysicalNode>();
        physicalNodes.add(this);
        return physicalNodes;
    }

    @Override
    public List<PhysicalNode<PK, D, F>> getPhysicalNodesForClient(String clientName) {
        LinkedList<PhysicalNode<PK, D, F>> physicalNodes = new LinkedList<PhysicalNode<PK, D, F>>();
        if (clientName.equals(((PhysicalDatabeanFieldInfo)this.getFieldInfo()).getClientId().getName())) {
            physicalNodes.add(this);
        }
        return physicalNodes;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public ClientType<?, ?> getClientType() {
        return this.clientType;
    }

    @Override
    public PhysicalDatabeanFieldInfo<PK, D, F> getFieldInfo() {
        return this.fieldInfo;
    }
}

