/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.op.scan;

import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.op.raw.read.SortedStorageReader;
import io.datarouter.util.Require;
import io.datarouter.util.number.NumberFormatter;
import io.datarouter.util.tuple.Range;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortedStorageSamplingScanner<PK extends PrimaryKey<PK>>
implements Scanner<SortedStorageSample<PK>> {
    private static final Logger logger = LoggerFactory.getLogger(SortedStorageSamplingScanner.class);
    private final SortedStorageReader<PK, ?> node;
    private final Supplier<Boolean> shouldStop;
    private final Range<PK> range;
    private final int stride;
    private final int batchSize;
    private final boolean log;
    private PK startKey;
    private boolean startInclusive;
    private long total;
    private final Config strideConfig;
    private final Config scanKeysConfig;
    private PK lastSeenKey;
    private SortedStorageSample<PK> current;
    private boolean interruptDetected = false;
    private boolean interruptApplied = false;
    private boolean finished = false;

    public SortedStorageSamplingScanner(SortedStorageReader<PK, ?> node, Supplier<Boolean> shouldStop, Range<PK> range, int stride, int batchSize, boolean log) {
        this.node = node;
        this.shouldStop = shouldStop;
        this.range = range;
        this.stride = stride;
        this.batchSize = batchSize;
        this.log = log;
        this.startKey = (PrimaryKey)range.getStart();
        this.startInclusive = range.getStartInclusive();
        this.total = 0L;
        this.strideConfig = new Config().setLimit(1).setOffset(stride - 1);
        this.scanKeysConfig = new Config().setOutputBatchSize(batchSize);
    }

    public boolean advance() {
        if (this.finished || this.interruptApplied) {
            return false;
        }
        this.interruptApplied = this.interruptDetected;
        this.interruptDetected = this.shouldStop.get();
        Range strideRange = new Range(this.startKey, this.startInclusive, (Comparable)((PrimaryKey)this.range.getEnd()), this.range.getEndInclusive());
        this.lastSeenKey = this.node.scanKeys(strideRange, this.strideConfig).findFirst().orElse(null);
        if (this.lastSeenKey != null) {
            this.total += (long)this.stride;
            long numRpcs = 1L;
            long numKeysTransferred = 1L;
            this.current = new SortedStorageSample<PK>("stride", strideRange, this.lastSeenKey, numRpcs, numKeysTransferred, this.stride, this.total, this.interruptApplied);
            this.logCurrent();
            this.startKey = this.lastSeenKey;
            this.startInclusive = false;
            return true;
        }
        Range scanKeysRange = new Range(this.startKey, this.startInclusive, (Comparable)((PrimaryKey)this.range.getEnd()), this.range.getEndInclusive());
        long scanKeysCount = this.node.scanKeys(scanKeysRange, this.scanKeysConfig).each(pk -> {
            this.lastSeenKey = pk;
            Object object = this.lastSeenKey;
        }).count();
        this.finished = true;
        if (scanKeysCount == 0L) {
            return false;
        }
        this.total += scanKeysCount;
        long numRpcs = scanKeysCount / (long)this.batchSize;
        long numKeysTransferred = scanKeysCount;
        this.current = new SortedStorageSample<PK>("scanKeys", scanKeysRange, this.lastSeenKey, numRpcs, numKeysTransferred, scanKeysCount, this.total, this.interruptApplied);
        this.logCurrent();
        return true;
    }

    public SortedStorageSample<PK> current() {
        return this.current;
    }

    public void logCurrent() {
        if (this.log) {
            logger.warn("{}", this.current);
        }
    }

    public static class SortedStorageSample<PK extends PrimaryKey<PK>> {
        public final String strategy;
        public final Range<PK> range;
        public final PK lastSeenKey;
        public final long numRpcs;
        public final long numKeysTransferred;
        public final long sampleCount;
        public final long totalCount;
        public final boolean interrupted;

        public SortedStorageSample(String strategy, Range<PK> range, PK lastSeenKey, long numRpcs, long numKeysTransferred, long sampleCount, long totalCount, boolean interrupted) {
            this.strategy = strategy;
            this.range = range;
            this.lastSeenKey = lastSeenKey;
            this.numRpcs = numRpcs;
            this.numKeysTransferred = numKeysTransferred;
            this.sampleCount = sampleCount;
            this.totalCount = totalCount;
            if (sampleCount > 0L) {
                Require.isTrue((totalCount > 0L ? 1 : 0) != 0);
                Require.notNull(lastSeenKey, (String)"lastSeenKey required");
            }
            this.interrupted = interrupted;
        }

        public String toString() {
            return String.format("%s counted=%s total=%s interrupted=%s range=%s", this.strategy, NumberFormatter.addCommas((Number)this.sampleCount), NumberFormatter.addCommas((Number)this.totalCount), this.interrupted, this.range);
        }
    }

    public static class SortedStorageSamplingScannerBuilder<PK extends PrimaryKey<PK>> {
        private final SortedStorageReader<PK, ?> node;
        private Supplier<Boolean> shouldStop;
        private Range<PK> range;
        private int stride;
        private int batchSize;
        private boolean log;

        public SortedStorageSamplingScannerBuilder(SortedStorageReader<PK, ?> node) {
            this.node = node;
            this.shouldStop = () -> false;
            this.range = Range.everything();
            this.stride = 100000;
            this.batchSize = 1000;
            this.log = false;
        }

        public SortedStorageSamplingScannerBuilder<PK> withShouldStop(Supplier<Boolean> shouldStop) {
            this.shouldStop = shouldStop;
            return this;
        }

        public SortedStorageSamplingScannerBuilder<PK> withRange(Range<PK> range) {
            this.range = range;
            return this;
        }

        public SortedStorageSamplingScannerBuilder<PK> withStride(int stride) {
            this.stride = stride;
            return this;
        }

        public SortedStorageSamplingScannerBuilder<PK> withBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public SortedStorageSamplingScannerBuilder<PK> withLog(boolean log) {
            this.log = log;
            return this;
        }

        public SortedStorageSamplingScanner<PK> build() {
            return new SortedStorageSamplingScanner<PK>(this.node, this.shouldStop, this.range, this.stride, this.batchSize, this.log);
        }
    }
}

