/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.serialize.fieldcache;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.exception.DataAccessException;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.storage.serialize.fieldcache.DatabeanFieldInfo;
import io.datarouter.storage.serialize.fieldcache.PhysicalDatabeanFieldInfo;
import io.datarouter.util.lang.ReflectionTool;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class FieldGeneratorTool {
    private static final int MAX_RANDOM_ID_GENERATION_ATTEMPTS = 10;

    public static <PK extends PrimaryKey<PK>, D extends Databean<PK, D>> void generateAndSetValueForFieldIfNecessary(PhysicalDatabeanFieldInfo<PK, D, ?> fieldInfo, D databean) {
        FieldGeneratorTool.optFieldToGenerate(fieldInfo, databean).ifPresent(field -> FieldGeneratorTool.generateAndSetValueForField(fieldInfo, databean, field, bean -> true));
    }

    public static <PK extends PrimaryKey<PK>, D extends Databean<PK, D>> void generateAndSetValueForField(PhysicalDatabeanFieldInfo<PK, D, ?> fieldInfo, D databean, io.datarouter.model.field.Field<?> field, Predicate<D> valueChecker) {
        int attempts = 0;
        while (attempts++ < 10) {
            FieldGeneratorTool.setAutoGeneratedId(fieldInfo, databean, field.getKey().generateRandomValue());
            if (!valueChecker.test(databean)) continue;
            return;
        }
        throw new DataAccessException("error generating random id for " + fieldInfo.getTableName());
    }

    public static void setAutoGeneratedId(DatabeanFieldInfo<?, ?, ?> fieldInfo, Databean<?, ?> databean, Object id) {
        String autoGeneratedFieldName = fieldInfo.getAutogeneratedFieldName();
        Class<?> primaryKeyClass = fieldInfo.getPrimaryKeyClass();
        Field autogeneratedField = ReflectionTool.getCachedDeclaredFieldIncludingAncestors(primaryKeyClass, (String)autoGeneratedFieldName);
        ReflectionTool.set((Field)autogeneratedField, (Object)databean.getKey(), (Object)id);
    }

    public static Optional<io.datarouter.model.field.Field<?>> optFieldToGenerate(DatabeanFieldInfo<?, ?, ?> fieldInfo, Databean<?, ?> databean) {
        Optional<io.datarouter.model.field.Field<?>> generatedField;
        if (fieldInfo.getAutoGeneratedType().isGenerated() && (generatedField = FieldGeneratorTool.findGeneratedField(databean)).isPresent() && generatedField.get().getValue() == null) {
            return generatedField;
        }
        return Optional.empty();
    }

    private static Optional<io.datarouter.model.field.Field<?>> findGeneratedField(Databean<?, ?> databean) {
        List fields = databean.getKeyFields();
        for (io.datarouter.model.field.Field field : fields) {
            if (!field.getKey().getAutoGeneratedType().isGenerated()) continue;
            return Optional.of(field);
        }
        return Optional.empty();
    }
}

