/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.servertype;

import io.datarouter.storage.servertype.ServerType;
import io.datarouter.storage.servertype.ServerTypes;
import io.datarouter.storage.servertype.SingleServerType;
import io.datarouter.util.web.HtmlSelectOptionBean;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class BaseServerTypes
implements ServerTypes {
    private final Set<ServerType> serverTypes = new TreeSet<ServerType>();
    private final ServerType webServerType;
    private final ServerType jobServerType;
    private final ServerType jobletServerType;

    public BaseServerTypes(ServerType defaultServerType) {
        this(defaultServerType, defaultServerType, defaultServerType);
    }

    protected BaseServerTypes(ServerType webServerType, ServerType jobServerType, ServerType jobletServerType) {
        this.serverTypes.add(ServerType.ALL);
        this.serverTypes.add(ServerType.DEV);
        this.serverTypes.add(ServerType.UNKNOWN);
        this.webServerType = webServerType;
        this.jobServerType = jobServerType;
        this.jobletServerType = jobletServerType;
        this.serverTypes.addAll(Arrays.asList(webServerType, jobServerType, jobletServerType));
    }

    public static ServerType makeProduction(String persistentString) {
        return new SingleServerType(persistentString, true);
    }

    public BaseServerTypes add(ServerType serverType) {
        this.serverTypes.add(serverType);
        return this;
    }

    public ServerType[] values() {
        return (ServerType[])this.serverTypes.toArray(ServerType[]::new);
    }

    @Override
    public ServerType getWebServerType() {
        return this.webServerType;
    }

    @Override
    public ServerType getJobServerType() {
        return this.jobServerType;
    }

    @Override
    public ServerType getJobletServerType() {
        return this.jobletServerType;
    }

    @Override
    public ServerType fromPersistentString(String str) {
        return Arrays.stream(this.values()).filter(serverType -> serverType.getPersistentString().equals(str)).findAny().orElse(null);
    }

    @Override
    public List<HtmlSelectOptionBean> getHtmlSelectOptionsVarNames() {
        return Arrays.stream(this.values()).map(serverType -> new HtmlSelectOptionBean(serverType.getDisplay(), serverType.getPersistentString())).collect(Collectors.toList());
    }
}

