/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.setting;

import io.datarouter.storage.config.environment.DatarouterEnvironmentType;
import io.datarouter.storage.servertype.ServerType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class DefaultSettingValue<T> {
    private T globalDefault;
    private final Map<DatarouterEnvironmentType, T> valueByEnvironmentType;
    private final Map<DatarouterEnvironmentType, Map<String, T>> valueByServerTypeByEnvironmentType;
    private final Map<DatarouterEnvironmentType, Map<String, T>> valueByServerNameByEnvironmentType;
    private final Map<DatarouterEnvironmentType, Map<String, T>> valueByEnvironmentNameByEnvironmentType;

    public DefaultSettingValue(T globalDefault) {
        this.globalDefault = globalDefault;
        this.valueByEnvironmentType = new HashMap<DatarouterEnvironmentType, T>();
        this.valueByServerTypeByEnvironmentType = new HashMap<DatarouterEnvironmentType, Map<String, T>>();
        this.valueByServerNameByEnvironmentType = new HashMap<DatarouterEnvironmentType, Map<String, T>>();
        this.valueByEnvironmentNameByEnvironmentType = new HashMap<DatarouterEnvironmentType, Map<String, T>>();
    }

    public DefaultSettingValue<T> withEnvironmentType(Supplier<DatarouterEnvironmentType> environmentType, T value) {
        return this.withEnvironmentType(environmentType.get(), value);
    }

    public DefaultSettingValue<T> withEnvironmentType(DatarouterEnvironmentType environmentType, T value) {
        this.valueByEnvironmentType.put(environmentType, value);
        return this;
    }

    public DefaultSettingValue<T> withEnvironmentName(Supplier<DatarouterEnvironmentType> environmentType, String environment, T value) {
        return this.withEnvironmentName(environmentType.get(), environment, value);
    }

    public DefaultSettingValue<T> withEnvironmentName(DatarouterEnvironmentType environmentType, String environment, T value) {
        this.valueByEnvironmentNameByEnvironmentType.putIfAbsent(environmentType, new HashMap());
        this.valueByEnvironmentNameByEnvironmentType.get(environmentType).put(environment, value);
        return this;
    }

    public DefaultSettingValue<T> withServerType(Supplier<DatarouterEnvironmentType> environmentType, ServerType serverType, T value) {
        return this.withServerType(environmentType.get(), serverType, value);
    }

    public DefaultSettingValue<T> withServerType(DatarouterEnvironmentType environmentType, ServerType serverType, T value) {
        this.valueByServerTypeByEnvironmentType.putIfAbsent(environmentType, new HashMap());
        this.valueByServerTypeByEnvironmentType.get(environmentType).put(serverType.getPersistentString(), value);
        return this;
    }

    public DefaultSettingValue<T> withServerName(Supplier<DatarouterEnvironmentType> environmentType, String serverName, T value) {
        return this.withServerName(environmentType.get(), serverName, value);
    }

    public DefaultSettingValue<T> withServerName(DatarouterEnvironmentType environmentType, String serverName, T value) {
        this.valueByServerNameByEnvironmentType.putIfAbsent(environmentType, new HashMap());
        this.valueByServerNameByEnvironmentType.get(environmentType).put(serverName, value);
        return this;
    }

    public DefaultSettingValue<T> setGlobalDefault(T value) {
        this.globalDefault = value;
        return this;
    }

    public Map<DatarouterEnvironmentType, Map<String, T>> getValueByServerTypeByEnvironmentType() {
        return this.valueByServerTypeByEnvironmentType;
    }

    public Map<DatarouterEnvironmentType, Map<String, T>> getValueByServerNameByEnvironmentType() {
        return this.valueByServerNameByEnvironmentType;
    }

    public Map<DatarouterEnvironmentType, Map<String, T>> getValueByEnvironmentNameByEnvironmentType() {
        return this.valueByEnvironmentNameByEnvironmentType;
    }

    public Map<DatarouterEnvironmentType, T> getValueByEnvironmentType() {
        return this.valueByEnvironmentType;
    }

    public Map<String, T> getValueByServerType(DatarouterEnvironmentType environmentType) {
        return this.valueByServerTypeByEnvironmentType.get(environmentType);
    }

    public Map<String, T> getValueByServerName(DatarouterEnvironmentType environmentType) {
        return this.valueByServerNameByEnvironmentType.get(environmentType);
    }

    public T getGlobalDefault() {
        return this.globalDefault;
    }

    public T getValue(String environmentTypeString, String environmentName, ServerType serverType, String serverName) {
        return this.getValue(new DatarouterEnvironmentType(environmentTypeString), environmentName, serverType, serverName);
    }

    public T getValue(DatarouterEnvironmentType environmentType, String environmentName, ServerType serverType, String serverName) {
        String serverTypeString = serverType == null ? null : serverType.getPersistentString();
        return this.getValue(environmentType, environmentName, serverTypeString, serverName);
    }

    public T getValue(DatarouterEnvironmentType environmentType, String environmentName, String serverTypeString, String serverName) {
        T value;
        T value2;
        T value3;
        Map<String, T> valueByEnvironmentType = this.valueByEnvironmentNameByEnvironmentType.get(environmentType);
        if (valueByEnvironmentType != null && (value3 = valueByEnvironmentType.get(environmentName)) != null) {
            return value3;
        }
        Map<String, T> valueByServerType = this.valueByServerTypeByEnvironmentType.get(environmentType);
        if (valueByServerType != null && (value2 = valueByServerType.get(serverTypeString)) != null) {
            return value2;
        }
        Map<String, T> valueByServerName = this.valueByServerNameByEnvironmentType.get(environmentType);
        if (valueByServerName != null && (value = valueByServerName.get(serverName)) != null) {
            return value;
        }
        return this.valueByEnvironmentType.getOrDefault(environmentType, this.globalDefault);
    }
}

