/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.setting;

import io.datarouter.storage.setting.Setting;
import io.datarouter.util.string.StringTool;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;

public class SettingByGroup<T> {
    private final String name;
    private final Map<String, Setting<T>> settings;
    private final BiFunction<String, T, Setting<T>> settingRegistrar;

    public SettingByGroup(String name, T defaultValue, BiFunction<String, T, Setting<T>> settingRegistrar) {
        this.name = name;
        this.settings = new ConcurrentHashMap<String, Setting<T>>();
        this.settingRegistrar = settingRegistrar;
        this.addSetting("", defaultValue);
    }

    public void addSetting(String group, T defaultValue) {
        String settingName = this.getGroupSettingName(group);
        this.settings.put(settingName, this.settingRegistrar.apply(settingName, (String)defaultValue));
    }

    public Setting<T> getSetting(String group) {
        return this.settings.getOrDefault(this.getGroupSettingName(group), this.settings.get(this.name));
    }

    public Setting<T> getDefaultSetting() {
        return this.settings.get(this.name);
    }

    private String getGroupSettingName(String group) {
        String groupSettingPostfix = StringTool.notEmpty((String)group) ? "." + group : "";
        return String.valueOf(this.name) + groupSettingPostfix;
    }
}

