/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.setting;

import io.datarouter.storage.setting.AdditionalSettingRootsFinder;
import io.datarouter.storage.setting.DatarouterSettingCategory;
import io.datarouter.storage.setting.SettingCategory;
import io.datarouter.storage.setting.SettingFinder;
import io.datarouter.storage.setting.SettingNode;
import io.datarouter.storage.setting.cached.CachedSetting;
import io.datarouter.util.string.StringTool;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

public class SettingRoot
extends SettingNode {
    private final Set<SettingNode> rootNodes = Collections.synchronizedSet(new LinkedHashSet());
    private final Map<SettingCategory, Set<SettingNode>> map = Collections.synchronizedMap(new LinkedHashMap());
    private final SettingCategory category;

    public SettingRoot(SettingFinder finder, SettingCategory category, String name) {
        super(finder, name);
        this.rootNodes.add(this);
        this.category = category;
    }

    private SettingRoot(SettingFinder finder, AdditionalSettingRootsFinder additionalSettingRootsFinder, SettingCategory category, String name) {
        super(finder, name);
        additionalSettingRootsFinder.getAdditionalSettingRoots().forEach(this::dependsOn);
        this.category = category;
    }

    private void dependsOn(SettingRoot settingNode) {
        this.rootNodes.add(settingNode);
        settingNode.rootNodes.forEach(this.rootNodes::add);
        this.addToMap(settingNode);
    }

    public Optional<SettingNode> getNode(String nodeName) {
        for (SettingNode settingNode : this.rootNodes) {
            if (!nodeName.startsWith(settingNode.getName())) continue;
            return settingNode.getNodeByName(nodeName);
        }
        return Optional.empty();
    }

    public Optional<SettingNode> getMostRecentAncestorNode(String nodeName) {
        for (SettingNode settingNode : this.rootNodes) {
            if (!nodeName.startsWith(settingNode.getName())) continue;
            return settingNode.getMostRecentAncestorNodeByName(nodeName);
        }
        return Optional.empty();
    }

    public List<SettingNode> getDescendants(String nodeName) {
        for (SettingNode settingNode : this.rootNodes) {
            if (!nodeName.startsWith(settingNode.getName())) continue;
            return settingNode.getDescendanceByName(nodeName);
        }
        return null;
    }

    public List<SettingNode> getRootNodesSortedByShortName() {
        return this.rootNodes.stream().sorted(Comparator.comparing(SettingNode::getShortName)).collect(Collectors.toList());
    }

    public Optional<CachedSetting<?>> getSettingByName(String name) {
        return this.getNode(name.substring(0, name.lastIndexOf(".") + 1)).map(SettingNode::getSettings).map(settings -> (CachedSetting)settings.get(name));
    }

    public boolean isRecognized(String settingName) {
        String rootName = StringTool.getStringBeforeFirstOccurrence((char)'.', (String)settingName);
        return this.isRecognizedRootName(rootName);
    }

    public boolean isRecognizedRootName(String rootNameWithoutTrailingDot) {
        return this.rootNodes.stream().map(SettingNode::getShortName).anyMatch(shortName -> shortName.equals(rootNameWithoutTrailingDot));
    }

    public SettingCategory getSettingCategory() {
        return this.category;
    }

    private void addToMap(SettingRoot root) {
        this.map.computeIfAbsent(root.getSettingCategory(), $ -> new LinkedHashSet()).add(root);
    }

    public Map<SettingCategory, Set<SettingNode>> getRootNodesByCategory() {
        return this.map;
    }

    @Singleton
    public static class SettingRootFinder
    extends SettingRoot {
        @Inject
        private SettingRootFinder(SettingFinder finder, AdditionalSettingRootsFinder additionalSettingRootsFinder) {
            super(finder, additionalSettingRootsFinder, DatarouterSettingCategory.DATAROUTER, "datarouter.");
        }
    }
}

