/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.setting.cached;

import io.datarouter.storage.config.environment.DatarouterEnvironmentType;
import io.datarouter.storage.servertype.ServerType;
import io.datarouter.storage.setting.DefaultSettingValue;
import io.datarouter.storage.setting.Setting;
import io.datarouter.storage.setting.SettingFinder;
import io.datarouter.util.cached.Cached;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public abstract class CachedSetting<T>
extends Cached<T>
implements Setting<T> {
    protected final SettingFinder finder;
    protected final String name;
    protected final DefaultSettingValue<T> defaultSettingValue;
    protected boolean hasCustomValues;
    protected boolean hasRedundantCustomValues;

    public CachedSetting(SettingFinder finder, String name, DefaultSettingValue<T> defaultValue) {
        super(15L, TimeUnit.SECONDS);
        this.finder = finder;
        this.name = name;
        this.defaultSettingValue = defaultValue;
    }

    public String toString() {
        return "CachedSetting=" + this.name;
    }

    protected T reload() {
        return (T)this.finder.getSettingValue(this.name).map(this::parseStringValue).orElseGet(this::getDefaultValue);
    }

    public void validateAllCustomValuesCanBeParsed() {
        try {
            this.finder.getAllCustomSettingValues(this.name).forEach(this::parseStringValue);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("value is not valid for setting name=" + this.name, e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultSettingValue.getValue(this.finder.getEnvironmentType(), this.finder.getEnvironmentName(), this.finder.getServerType(), this.finder.getServerName());
    }

    @Override
    public boolean getHasCustomValue() {
        return this.get() != null;
    }

    @Override
    public boolean getHasRedundantCustomValue() {
        return Objects.equals(this.getDefaultValue(), this.get());
    }

    public CachedSetting<T> setGlobalDefault(T value) {
        this.defaultSettingValue.setGlobalDefault(value);
        return this;
    }

    public CachedSetting<T> setEnvironmentTypeDefault(Supplier<DatarouterEnvironmentType> environmentType, T value) {
        this.defaultSettingValue.withEnvironmentType(environmentType, value);
        return this;
    }

    public CachedSetting<T> setEnvironmentTypesDefault(Collection<Supplier<DatarouterEnvironmentType>> environmentTypes, T value) {
        environmentTypes.forEach(environmentType -> {
            CachedSetting<Object> cachedSetting = this.setEnvironmentTypeDefault((Supplier<DatarouterEnvironmentType>)environmentType, value);
        });
        return this;
    }

    public CachedSetting<T> setEnvironmentNameDefault(Supplier<DatarouterEnvironmentType> environmentType, String environmentName, T value) {
        this.defaultSettingValue.withEnvironmentName(environmentType, environmentName, value);
        return this;
    }

    public CachedSetting<T> setServerTypeDefault(Supplier<DatarouterEnvironmentType> environmentType, ServerType serverType, T value) {
        this.defaultSettingValue.withServerType(environmentType, serverType, value);
        return this;
    }

    public CachedSetting<T> setServerNameDefault(Supplier<DatarouterEnvironmentType> environmentType, String serverName, T value) {
        this.defaultSettingValue.withServerName(environmentType, serverName, value);
        return this;
    }

    public DefaultSettingValue<T> getDefaultSettingValue() {
        return this.defaultSettingValue;
    }
}

