/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.util;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.util.BaseNodeVacuum;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class DatabeanVacuum<PK extends PrimaryKey<PK>, D extends Databean<PK, D>>
extends BaseNodeVacuum<PK, D> {
    private DatabeanVacuum(Scanner<D> scanner, Consumer<Collection<PK>> deleteConsumer, int deleteBatchSize, Predicate<D> shouldDelete, Optional<Integer> logBatchSize) {
        super(scanner, deleteConsumer, deleteBatchSize, logBatchSize, shouldDelete);
    }

    @Override
    protected PK getKey(D databean) {
        return (PK)databean.getKey();
    }

    public static class DatabeanVacuumBuilder<PK extends PrimaryKey<PK>, D extends Databean<PK, D>>
    extends BaseNodeVacuum.BaseDatabeanVacuumBuilder<PK, D> {
        public DatabeanVacuumBuilder(Scanner<D> scanner, Predicate<D> shouldDelete, Consumer<Collection<PK>> deleteConsumer) {
            super(scanner, shouldDelete, deleteConsumer);
        }

        public DatabeanVacuumBuilder<PK, D> withDeleteBatchSize(int batchSize) {
            this.deleteBatchSize = batchSize;
            return this;
        }

        public DatabeanVacuumBuilder<PK, D> withLogBatchSize(int logBatchSize) {
            this.logBatchSize = Optional.of(logBatchSize);
            return this;
        }

        public DatabeanVacuum<PK, D> build() {
            return new DatabeanVacuum(this.scanner, this.deleteConsumer, this.deleteBatchSize, this.shouldDelete, this.logBatchSize);
        }
    }
}

