/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.util;

import io.datarouter.model.field.compare.FieldSetRangeFilter;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.util.tuple.Range;
import java.util.List;

public class KeyRangeTool {
    public static <PK extends PrimaryKey<PK>> Range<PK> forPrefix(PK prefix) {
        return new Range(prefix, true, prefix, true);
    }

    public static <PK extends PrimaryKey<PK>> Range<PK> forPrefixWithWildcard(String prefixString, KeyWithStringFieldSuffixProvider<PK> keyWithStringFieldSuffixProvider) {
        if (prefixString == null) {
            return KeyRangeTool.forPrefix(keyWithStringFieldSuffixProvider.createWithSuffixStringField(null));
        }
        String endString = KeyRangeTool.incrementLastChar(prefixString);
        PK startKey = keyWithStringFieldSuffixProvider.createWithSuffixStringField(prefixString);
        PK endKey = keyWithStringFieldSuffixProvider.createWithSuffixStringField(endString);
        return new Range(startKey, endKey);
    }

    public static String incrementLastChar(String string) {
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            return String.valueOf('\u0000');
        }
        int lastCharPos = string.length() - 1;
        char lastChar = string.charAt(lastCharPos);
        if (lastChar == '\uffff') {
            return String.valueOf(string) + '\u0000';
        }
        return String.valueOf(string.substring(0, lastCharPos)) + (char)(lastChar + '\u0001');
    }

    public static <PK extends PrimaryKey<PK>> boolean contains(Range<PK> range, PK pk) {
        return !KeyRangeTool.isBeforeStartOfRange(range, pk) && !KeyRangeTool.isAfterEndOfRange(range, pk);
    }

    public static <PK extends PrimaryKey<PK>> boolean isBeforeStartOfRange(Range<PK> range, PK pk) {
        return range != null && !range.matchesStart(pk);
    }

    public static <PK extends PrimaryKey<PK>> boolean isAfterEndOfRange(Range<PK> range, PK pk) {
        if (range == null || !range.hasEnd()) {
            return false;
        }
        return !FieldSetRangeFilter.isCandidateBeforeEndOfRange((List)pk.getFields(), (List)((PrimaryKey)range.getEnd()).getFields(), (boolean)range.getEndInclusive());
    }

    public static interface KeyWithStringFieldSuffixProvider<PK extends PrimaryKey<PK>> {
        public PK createWithSuffixStringField(String var1);
    }
}

