/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.util;

import io.datarouter.model.field.Field;
import io.datarouter.model.field.FieldSet;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.util.PercentFieldCodec;
import io.datarouter.util.Require;
import io.datarouter.util.StreamTool;
import io.datarouter.util.lang.ReflectionTool;
import io.datarouter.util.string.StringTool;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class PrimaryKeyPercentCodec {
    public static String encode(PrimaryKey<?> pk) {
        return PercentFieldCodec.encodeFields((List)pk.getFields());
    }

    public static <PK extends PrimaryKey<PK>> String encodeMulti(Iterable<PK> pks, char delimiter) {
        Require.isTrue((boolean)PercentFieldCodec.isValidExternalSeparator((char)delimiter), (String)("invalid delimiter:" + delimiter));
        return StreamTool.stream(pks).map(PrimaryKeyPercentCodec::encode).collect(Collectors.joining(Character.toString(delimiter)));
    }

    public static <PK extends PrimaryKey<PK>> PK decode(Class<PK> pkClass, String encodedPk) {
        if (encodedPk == null) {
            return null;
        }
        PrimaryKey pk = (PrimaryKey)ReflectionTool.create(pkClass);
        List tokens = PercentFieldCodec.decode((String)encodedPk);
        int index = 0;
        for (Field field : pk.getFields((FieldSet)pk)) {
            if (index > tokens.size() - 1) break;
            field.fromString((String)tokens.get(index));
            field.setUsingReflection((Object)pk, field.getValue());
            field.setValue(null);
            ++index;
        }
        return (PK)pk;
    }

    public static <PK extends PrimaryKey<PK>> List<PK> decodeMulti(Class<PK> pkClass, char delimiter, String encodedPks) {
        ArrayList eachEncodedPk = StringTool.splitOnCharNoRegex((String)encodedPks, (char)delimiter, (boolean)false);
        return eachEncodedPk.stream().map(encodedPk -> PrimaryKeyPercentCodec.decode(pkClass, encodedPk)).collect(Collectors.toList());
    }
}

