/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.client;

public class ConnectionHandle {
    public static final int OUTERMOST_TICKET_NUMBER = 1;
    private Thread thread;
    private long threadId;
    private String clientName;
    private long handleNum;
    private int numTickets;

    public ConnectionHandle(Thread thread, String clientName, long handleNum, int numTickets) {
        this(thread.getId(), clientName, handleNum, numTickets);
        this.thread = thread;
    }

    protected ConnectionHandle(long threadId, String clientName, long handleNum, int numTickets) {
        this.threadId = threadId;
        this.clientName = clientName;
        this.handleNum = handleNum;
        this.numTickets = numTickets;
    }

    public int incrementNumTickets() {
        return ++this.numTickets;
    }

    public int decrementNumTickets() {
        return --this.numTickets;
    }

    public boolean isOutermostHandle() {
        return this.numTickets == 1;
    }

    public String toString() {
        return "[" + this.threadId + "," + this.clientName + "," + this.handleNum + "]#" + this.numTickets + "-" + this.thread.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clientName == null ? 0 : this.clientName.hashCode());
        result = 31 * result + (int)(this.handleNum ^ this.handleNum >>> 32);
        result = 31 * result + (int)(this.threadId ^ this.threadId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionHandle other = (ConnectionHandle)obj;
        if (this.clientName == null ? other.clientName != null : !this.clientName.equals(other.clientName)) {
            return false;
        }
        if (this.handleNum != other.handleNum) {
            return false;
        }
        return this.threadId == other.threadId;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public long getHandleNum() {
        return this.handleNum;
    }

    public void setHandleNum(long handleNum) {
        this.handleNum = handleNum;
    }

    public int getNumTickets() {
        return this.numTickets;
    }

    public void setNumTickets(int numTickets) {
        this.numTickets = numTickets;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public void setThreadId(long threadId) {
        this.threadId = threadId;
    }
}

