/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.config;

import io.datarouter.storage.client.ClientOptionsFactory;
import io.datarouter.storage.config.BaseStoragePlugin;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.storage.config.schema.SchemaUpdateOptionsFactory;
import io.datarouter.storage.config.setting.DatarouterSettingOverrides;
import io.datarouter.storage.config.setting.DatarouterStorageSettingRoot;
import io.datarouter.storage.dao.Dao;
import io.datarouter.storage.dao.DaoClasses;
import io.datarouter.storage.servertype.ServerTypeDetector;
import io.datarouter.storage.servertype.ServerTypes;
import io.datarouter.storage.setting.SettingRootsSupplier;
import java.util.ArrayList;
import java.util.List;

public class DatarouterStoragePlugin
extends BaseStoragePlugin {
    private final ServerTypes serverTypes;
    private final Class<? extends ServerTypeDetector> serverTypeDetectorClass;
    private final DatarouterProperties datarouterProperties;
    private final Class<? extends DatarouterSettingOverrides> settingOverridesClass;
    private final SettingRootsSupplier.SettingRoots settingRoots;
    private final Class<? extends ClientOptionsFactory> clientOptionsFactoryClass;
    private final Class<? extends SchemaUpdateOptionsFactory> schemaUpdateOptionsFactoryClass;
    private final List<Class<? extends Dao>> daoClasses;

    private DatarouterStoragePlugin() {
        this(null, null, null, null, null, null, null, null);
    }

    private DatarouterStoragePlugin(ServerTypes serverTypes, Class<? extends ServerTypeDetector> serverTypeDetectorClass, DatarouterProperties datarouterProperties, Class<? extends DatarouterSettingOverrides> settingOverridesClass, SettingRootsSupplier.SettingRoots settingRoots, Class<? extends ClientOptionsFactory> clientOptionsFactoryClass, Class<? extends SchemaUpdateOptionsFactory> schemaUpdateOptionsFactoryClass, List<Class<? extends Dao>> daoClasses) {
        this.addSettingRoot(DatarouterStorageSettingRoot.class);
        this.serverTypes = serverTypes;
        this.serverTypeDetectorClass = serverTypeDetectorClass;
        this.datarouterProperties = datarouterProperties;
        this.settingOverridesClass = settingOverridesClass;
        this.settingRoots = settingRoots;
        this.clientOptionsFactoryClass = clientOptionsFactoryClass;
        this.schemaUpdateOptionsFactoryClass = schemaUpdateOptionsFactoryClass;
        this.daoClasses = daoClasses;
    }

    public String getName() {
        return "DatarouterStorage";
    }

    public void configure() {
        this.bind(ServerTypes.class).toInstance((Object)this.serverTypes);
        this.bindActual(ServerTypeDetector.class, this.serverTypeDetectorClass);
        this.bindActualInstance(DatarouterProperties.class, this.datarouterProperties);
        if (this.settingOverridesClass != null) {
            this.bind(this.settingOverridesClass).asEagerSingleton();
        }
        if (this.settingRoots != null) {
            this.bindActualInstance(SettingRootsSupplier.class, this.settingRoots);
        }
        if (this.clientOptionsFactoryClass != null) {
            this.bindActual(ClientOptionsFactory.class, this.clientOptionsFactoryClass);
        }
        if (this.schemaUpdateOptionsFactoryClass != null) {
            this.bindActual(SchemaUpdateOptionsFactory.class, this.schemaUpdateOptionsFactoryClass);
        }
        this.bind(DaoClasses.class).toInstance((Object)new DaoClasses(this.daoClasses));
    }

    public static class DatarouterStoragePluginBuilder {
        private final ServerTypes serverTypes;
        private final DatarouterProperties datarouterProperties;
        private Class<? extends ServerTypeDetector> serverTypeDetectorClass = ServerTypeDetector.NoOpServerTypeDetector.class;
        private Class<? extends DatarouterSettingOverrides> settingOverridesClass;
        private SettingRootsSupplier.SettingRoots settingRoots;
        private Class<? extends ClientOptionsFactory> clientOptionsFactoryClass;
        private Class<? extends SchemaUpdateOptionsFactory> schemaUpdateOptionsFactoryClass;
        private List<Class<? extends Dao>> daoClasses = new ArrayList<Class<? extends Dao>>();

        public DatarouterStoragePluginBuilder(ServerTypes serverTypes, DatarouterProperties datarouterProperties) {
            this.serverTypes = serverTypes;
            this.datarouterProperties = datarouterProperties;
        }

        public DatarouterStoragePluginBuilder setServerTypeDetector(Class<? extends ServerTypeDetector> serveTypeDetectorClass) {
            this.serverTypeDetectorClass = serveTypeDetectorClass;
            return this;
        }

        public DatarouterStoragePluginBuilder setSettingOverridesClass(Class<? extends DatarouterSettingOverrides> settingOverridesClass) {
            this.settingOverridesClass = settingOverridesClass;
            return this;
        }

        public DatarouterStoragePluginBuilder setSettingRootsClass(SettingRootsSupplier.SettingRoots settingRoots) {
            this.settingRoots = settingRoots;
            return this;
        }

        public DatarouterStoragePluginBuilder setClientOptionsFactoryClass(Class<? extends ClientOptionsFactory> clientOptionsFactoryClass) {
            this.clientOptionsFactoryClass = clientOptionsFactoryClass;
            return this;
        }

        public DatarouterStoragePluginBuilder setSchemaUpdateOptionsFactoryClass(Class<? extends SchemaUpdateOptionsFactory> schemaUpdateOptionsFactoryClass) {
            this.schemaUpdateOptionsFactoryClass = schemaUpdateOptionsFactoryClass;
            return this;
        }

        public DatarouterStoragePluginBuilder addDao(Class<? extends Dao> dao) {
            this.daoClasses.add(dao);
            return this;
        }

        public DatarouterStoragePluginBuilder addDaosClasses(List<Class<? extends Dao>> daos) {
            this.daoClasses.addAll(daos);
            return this;
        }

        public DatarouterStoragePlugin getSimplePluginData() {
            return new DatarouterStoragePlugin();
        }

        public DatarouterStoragePlugin build() {
            return new DatarouterStoragePlugin(this.serverTypes, this.serverTypeDetectorClass, this.datarouterProperties, this.settingOverridesClass, this.settingRoots, this.clientOptionsFactoryClass, this.schemaUpdateOptionsFactoryClass, this.daoClasses);
        }
    }
}

