/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.adapter.BaseAdapter;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NodeTool {
    public static <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> PhysicalNode<PK, D, F> extractSinglePhysicalNode(Node<PK, D, F> node) {
        Iterator<PhysicalNode<PK, D, F>> physicalNodes = node.getPhysicalNodes().iterator();
        PhysicalNode<PK, D, F> physicalNode = physicalNodes.next();
        if (physicalNodes.hasNext()) {
            throw new RuntimeException(node + " has multiple physical nodes, you need to pick one");
        }
        return physicalNode;
    }

    public static List<Node<?, ?, ?>> getNodeAndDescendants(Node<?, ?, ?> parent) {
        ArrayList nodes = new ArrayList();
        NodeTool.addNodeAndDescendants(nodes, parent);
        return nodes;
    }

    public static void addNodeAndDescendants(List<Node<?, ?, ?>> nodes, Node<?, ?, ?> parent) {
        nodes.add(parent);
        List<Node<?, ?, ?>> children = parent.getChildNodes();
        for (Node<?, ?, ?> child : children) {
            NodeTool.addNodeAndDescendants(nodes, child);
        }
    }

    public static Node<?, ?, ?> getUnderlyingNode(Node<?, ?, ?> node) {
        while (node instanceof BaseAdapter) {
            node = ((BaseAdapter)node).getUnderlyingNode();
        }
        return node;
    }
}

