/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.adapter.availability;

import io.datarouter.storage.config.setting.impl.DatarouterClientAvailabilitySettings;
import io.datarouter.storage.config.setting.impl.DatarouterClientAvailabilitySettingsProvider;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.setting.Setting;
import java.util.Collection;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ClientAvailabilityService {
    @Inject
    private DatarouterClientAvailabilitySettingsProvider availabilitySettingsFactory;

    public boolean canWriteToAllPhysicalNodes(Node<?, ?, ?> node) {
        return this.getAvailablitySettingNode(node).map(availability -> availability.write).allMatch(Setting::get);
    }

    public boolean canReadFromAllPhysicalNodes(Node<?, ?, ?> node) {
        return this.getAvailablitySettingNode(node).map(availability -> availability.read).allMatch(Setting::get);
    }

    private Stream<DatarouterClientAvailabilitySettings.AvailabilitySettingNode> getAvailablitySettingNode(Node<?, ?, ?> node) {
        return node.getPhysicalNodes().stream().map(Node::getClientIds).flatMap(Collection::stream).distinct().map(this.availabilitySettingsFactory.get()::getAvailabilityForClientId);
    }
}

