/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.builder;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.entity.EntityPartitioner;
import io.datarouter.model.key.entity.base.DefaultEntityPartitioner;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.entity.DefaultEntity;
import io.datarouter.storage.node.entity.EntityNodeParams;
import io.datarouter.storage.node.factory.BaseNodeFactory;
import io.datarouter.storage.node.op.NodeOps;
import io.datarouter.storage.node.tableconfig.ClientTableEntityPrefixNameWrapper;
import io.datarouter.storage.node.tableconfig.NodewatchConfiguration;
import io.datarouter.storage.node.tableconfig.NodewatchConfigurationBuilder;
import java.util.function.Supplier;

public class NodeBuilder<EK extends EntityKey<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> {
    private final BaseNodeFactory nodeFactory;
    private final Supplier<Boolean> enableDiagnosticsSupplier;
    private final ClientId clientId;
    private final Supplier<EK> entityKeySupplier;
    private final Supplier<D> databeanSupplier;
    private final Supplier<F> fielderSupplier;
    private Supplier<EntityPartitioner<EK>> partitionerSupplier;
    private String tableName;
    private Integer schemaVersion;
    private NodewatchConfigurationBuilder nodewatchConfigurationBuilder;
    private boolean disableForcePrimary;

    public NodeBuilder(BaseNodeFactory nodeFactory, Supplier<Boolean> enableDiagnosticsSupplier, ClientId clientId, Supplier<EK> entityKeySupplier, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier) {
        this.nodeFactory = nodeFactory;
        this.enableDiagnosticsSupplier = enableDiagnosticsSupplier;
        this.clientId = clientId;
        this.entityKeySupplier = entityKeySupplier;
        this.databeanSupplier = databeanSupplier;
        this.fielderSupplier = fielderSupplier;
        this.partitionerSupplier = DefaultEntityPartitioner::new;
    }

    public NodeBuilder<EK, PK, D, F> withPartitionerSupplier(Supplier<EntityPartitioner<EK>> pertitionerSupplier) {
        this.partitionerSupplier = pertitionerSupplier;
        return this;
    }

    public NodeBuilder<EK, PK, D, F> withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public NodeBuilder<EK, PK, D, F> withSchemaVersion(Integer schemaVersion) {
        this.schemaVersion = schemaVersion;
        return this;
    }

    public NodeBuilder<EK, PK, D, F> withDisableForcePrimary(boolean disableForcePrimary) {
        this.disableForcePrimary = disableForcePrimary;
        return this;
    }

    public NodeBuilder<EK, PK, D, F> withNodewatchConfigurationBuilder(NodewatchConfigurationBuilder nodewatchConfigurationBuilder) {
        this.nodewatchConfigurationBuilder = nodewatchConfigurationBuilder;
        return this;
    }

    public NodeBuilder<EK, PK, D, F> withNodewatchThreshold(long threshold) {
        if (this.nodewatchConfigurationBuilder == null) {
            this.nodewatchConfigurationBuilder = new NodewatchConfigurationBuilder();
        }
        this.nodewatchConfigurationBuilder.withThreshold(threshold);
        return this;
    }

    public NodeBuilder<EK, PK, D, F> withNodewatchSampleSize(int sampleSize) {
        if (this.nodewatchConfigurationBuilder == null) {
            this.nodewatchConfigurationBuilder = new NodewatchConfigurationBuilder();
        }
        this.nodewatchConfigurationBuilder.withSampleSize(sampleSize);
        return this;
    }

    public NodeBuilder<EK, PK, D, F> withNodewatchBatchSize(int batchSize) {
        if (this.nodewatchConfigurationBuilder == null) {
            this.nodewatchConfigurationBuilder = new NodewatchConfigurationBuilder();
        }
        this.nodewatchConfigurationBuilder.withBatchSize(batchSize);
        return this;
    }

    public NodeBuilder<EK, PK, D, F> disableNodewatch() {
        if (this.nodewatchConfigurationBuilder == null) {
            this.nodewatchConfigurationBuilder = new NodewatchConfigurationBuilder();
        }
        this.nodewatchConfigurationBuilder.disable();
        return this;
    }

    public NodeBuilder<EK, PK, D, F> disableNodewatchPercentageAlert() {
        if (this.nodewatchConfigurationBuilder == null) {
            this.nodewatchConfigurationBuilder = new NodewatchConfigurationBuilder();
        }
        this.nodewatchConfigurationBuilder.disablePercentChangeAlert();
        return this;
    }

    public NodeBuilder<EK, PK, D, F> disableNodewatchThresholdAlert() {
        if (this.nodewatchConfigurationBuilder == null) {
            this.nodewatchConfigurationBuilder = new NodewatchConfigurationBuilder();
        }
        this.nodewatchConfigurationBuilder.disableMaxThresholdAlert();
        return this;
    }

    public <N extends NodeOps<PK, D>> N build() {
        String databeanName = ((Databean)this.databeanSupplier.get()).getDatabeanName();
        String entityName = String.valueOf(databeanName) + "Entity";
        String entityNodePrefix = null;
        String nodeTableName = this.tableName != null ? this.tableName : databeanName;
        NodewatchConfiguration tableConfig = null;
        if (this.nodewatchConfigurationBuilder != null) {
            tableConfig = this.nodewatchConfigurationBuilder.create(new ClientTableEntityPrefixNameWrapper(this.clientId.getName(), nodeTableName, entityNodePrefix));
        }
        NodeParams params = new NodeParams.NodeParamsBuilder(this.databeanSupplier, this.fielderSupplier).withClientId(this.clientId).withDiagnostics(this.enableDiagnosticsSupplier).withEntity(entityName, entityNodePrefix).withParentName(entityName).withTableName(nodeTableName).withSchemaVersion(this.schemaVersion).withTableConfiguration(tableConfig).withDisableForcePrimary(this.disableForcePrimary).build();
        EntityNodeParams<EK, DefaultEntity<EK>> entityNodeParams = new EntityNodeParams<EK, DefaultEntity<EK>>(String.valueOf(this.clientId.getName()) + "." + entityName, this.entityKeySupplier, DefaultEntity.supplier(this.entityKeySupplier), this.partitionerSupplier, entityName);
        return (N)((NodeOps)this.nodeFactory.create(entityNodeParams, params));
    }

    public <N extends NodeOps<PK, D>> N buildAndRegister() {
        return (N)((NodeOps)this.nodeFactory.register(this.build()));
    }
}

