/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.entity;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.entity.Entity;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientTableNodeNames;
import io.datarouter.storage.node.entity.BaseEntityNode;
import io.datarouter.storage.node.entity.EntityNodeParams;
import io.datarouter.storage.node.entity.PhysicalEntityNode;
import io.datarouter.storage.node.entity.SubEntitySortedMapStorageReaderNode;
import io.datarouter.storage.serialize.fieldcache.EntityFieldInfo;
import java.util.HashMap;
import java.util.Map;

public abstract class BasePhysicalEntityNode<EK extends EntityKey<EK>, E extends Entity<EK>>
extends BaseEntityNode<EK, E>
implements PhysicalEntityNode<EK, E> {
    protected final EntityFieldInfo<EK, E> entityFieldInfo;
    private final ClientTableNodeNames clientTableNodeNames;
    private final Map<String, SubEntitySortedMapStorageReaderNode<EK, ?, ?, ?>> nodeByQualifierPrefix;

    public BasePhysicalEntityNode(EntityNodeParams<EK, E> entityNodeParams, ClientTableNodeNames clientTableNodeNames) {
        super(clientTableNodeNames.getNodeName());
        this.entityFieldInfo = new EntityFieldInfo<EK, E>(entityNodeParams);
        this.clientTableNodeNames = clientTableNodeNames;
        this.nodeByQualifierPrefix = new HashMap();
    }

    @Override
    public <PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> void register(SubEntitySortedMapStorageReaderNode<EK, PK, D, F> subEntityNode) {
        super.register(subEntityNode);
        this.nodeByQualifierPrefix.put(subEntityNode.getEntityNodePrefix(), subEntityNode);
    }

    @Override
    public String getClientName() {
        return this.clientTableNodeNames.getClientName();
    }

    @Override
    public String getTableName() {
        return this.clientTableNodeNames.getTableName();
    }

    @Override
    public Map<String, ? extends SubEntitySortedMapStorageReaderNode<EK, ?, ?, ?>> getNodeByQualifierPrefix() {
        return this.nodeByQualifierPrefix;
    }

    @Override
    public EntityFieldInfo<EK, E> getEntityFieldInfo() {
        return this.entityFieldInfo;
    }
}

