/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.factory;

import io.datarouter.inject.DatarouterInjector;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.entity.Entity;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.key.primary.RegularPrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientNodeFactory;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.client.DatarouterClients;
import io.datarouter.storage.config.setting.DatarouterStorageSettingRoot;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.builder.WideNodeBuilder;
import io.datarouter.storage.node.entity.EntityNodeParams;
import io.datarouter.storage.node.factory.BaseNodeFactory;
import java.util.function.Supplier;
import javax.inject.Inject;

public class WideNodeFactory {
    @Inject
    private DatarouterInjector injector;
    @Inject
    private Datarouter datarouter;
    @Inject
    private DatarouterClients clients;
    @Inject
    private DatarouterStorageSettingRoot storageSettings;

    public <PK extends RegularPrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> WideNodeBuilder<PK, D, F> createWide(ClientId clientId, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier) {
        return new WideNodeBuilder(this.datarouter, this, this.storageSettings, clientId, databeanSupplier, fielderSupplier);
    }

    public <EK extends EntityKey<EK>, E extends Entity<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends Node<PK, D, F>> N subEntityNode(EntityNodeParams<EK, E> entityNodeParams, ClientId clientId, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier, String entityNodePrefix) {
        NodeParams.NodeParamsBuilder paramsBuilder = new NodeParams.NodeParamsBuilder(databeanSupplier, fielderSupplier).withClientId(clientId).withParentName(entityNodeParams.getNodeName()).withEntity(entityNodeParams.getEntityTableName(), entityNodePrefix).withDiagnostics(this.storageSettings.recordCallsites);
        return this.createSubEntity(entityNodeParams, paramsBuilder.build());
    }

    public <EK extends EntityKey<EK>, E extends Entity<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends Node<PK, D, F>> N subEntityNode(EntityNodeParams<EK, E> entityNodeParams, ClientId clientId, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier, String entityNodePrefix, String tableName) {
        NodeParams.NodeParamsBuilder paramsBuilder = new NodeParams.NodeParamsBuilder(databeanSupplier, fielderSupplier).withClientId(clientId).withParentName(entityNodeParams.getNodeName()).withEntity(entityNodeParams.getEntityTableName(), entityNodePrefix).withDiagnostics(this.storageSettings.recordCallsites).withTableName(tableName);
        return this.createSubEntity(entityNodeParams, paramsBuilder.build());
    }

    public <EK extends EntityKey<EK>, E extends Entity<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends Node<PK, D, F>> N createSubEntity(EntityNodeParams<EK, E> entityNodeParams, NodeParams<PK, D, F> nodeParams) {
        ClientType<?, ?> clientType = this.getClientTypeInstance(nodeParams.getClientId());
        ClientNodeFactory clientNodeFactory = this.getClientFactories(clientType);
        return BaseNodeFactory.cast(clientNodeFactory.createWrappedSubEntityNode(entityNodeParams, nodeParams));
    }

    private ClientType<?, ?> getClientTypeInstance(ClientId clientId) {
        return this.clients.getClientTypeInstance(clientId);
    }

    private ClientNodeFactory getClientFactories(ClientType<?, ?> clientType) {
        return (ClientNodeFactory)this.injector.getInstance(clientType.getClientNodeFactoryClass());
    }
}

