/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.tableconfig;

import io.datarouter.storage.node.tableconfig.ClientTableEntityPrefixNameWrapper;
import io.datarouter.storage.node.tableconfig.NodewatchConfiguration;

public class NodewatchConfigurationBuilder {
    public static final int DEFAULT_SAMPLE_SIZE = 1000000;
    public static final int DEFAULT_BATCH_SIZE = 1000;
    private boolean enabled = true;
    private int sampleSize = 1000000;
    private int batchSize = 1000;
    private boolean enabledPercentageAlert = true;
    private boolean enabledThresholdAlert = true;
    private Long threshold;

    public NodewatchConfigurationBuilder withSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
        return this;
    }

    public NodewatchConfigurationBuilder withBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public NodewatchConfigurationBuilder withThreshold(Long threshold) {
        this.threshold = threshold;
        return this;
    }

    public NodewatchConfigurationBuilder disable() {
        this.enabled = false;
        return this;
    }

    public NodewatchConfigurationBuilder disablePercentChangeAlert() {
        this.enabledPercentageAlert = false;
        return this;
    }

    public NodewatchConfigurationBuilder disableMaxThresholdAlert() {
        this.enabledThresholdAlert = false;
        return this;
    }

    public NodewatchConfiguration create(ClientTableEntityPrefixNameWrapper wrapper) {
        return new NodewatchConfiguration(wrapper, this.threshold, this.sampleSize, this.batchSize, this.enabled, this.enabledPercentageAlert, this.enabledThresholdAlert);
    }
}

