/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.type.index;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.index.IndexEntry;
import io.datarouter.model.index.KeyIndexEntry;
import io.datarouter.model.index.unique.UniqueKeyIndexEntry;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import io.datarouter.storage.node.op.raw.index.IndexListener;
import io.datarouter.storage.node.type.index.base.BaseIndexNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;

public class IndexMapStorageWriterListener<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>, IN extends SortedMapStorage.SortedMapStorageNode<IK, IE, IF>>
extends BaseIndexNode<PK, D, IK, IE, IF, IN>
implements IndexListener<PK, D> {
    public IndexMapStorageWriterListener(Supplier<IE> indexEntrySupplier, IN indexNode) {
        super(indexEntrySupplier, indexNode);
    }

    @Override
    public void onDelete(PK key, Config config) {
        if (key == null) {
            throw new IllegalArgumentException("invalid null key");
        }
        Object indexEntryBuilder = this.createIndexEntry();
        if (!(indexEntryBuilder instanceof KeyIndexEntry)) {
            throw new IllegalArgumentException("Unable to find index from PK, please call deleteDatabean method instead");
        }
        IndexEntry indexEntry = (IndexEntry)((UniqueKeyIndexEntry)indexEntryBuilder).fromPrimaryKey(key);
        ((SortedMapStorage.SortedMapStorageNode)this.indexNode).delete(indexEntry.getKey(), config);
    }

    @Override
    public void onDeleteDatabean(D databean, Config config) {
        Object sampleIndexEntry = this.createIndexEntry();
        List indexEntriesFromSingleDatabean = sampleIndexEntry.createFromDatabean(databean);
        Scanner.of((Iterable)indexEntriesFromSingleDatabean).map(Databean::getKey).flush(keys -> ((SortedMapStorage.SortedMapStorageNode)this.indexNode).deleteMulti(keys, config));
    }

    @Override
    public void onDeleteAll(Config config) {
        ((SortedMapStorage.SortedMapStorageNode)this.indexNode).deleteAll(config);
    }

    @Override
    public void onDeleteMulti(Collection<PK> keys, Config config) {
        if (keys == null) {
            return;
        }
        if (keys.contains(null)) {
            throw new IllegalArgumentException("invalid null key");
        }
        List<IE> indexEntries = this.getIndexEntriesFromPrimaryKeys(keys);
        Scanner.of(indexEntries).map(Databean::getKey).flush(iks -> ((SortedMapStorage.SortedMapStorageNode)this.indexNode).deleteMulti(iks, config));
    }

    @Override
    public void onDeleteMultiDatabeans(Collection<D> databeans, Config config) {
        List<IE> indexEntries = this.getIndexEntriesFromDatabeans(databeans);
        Scanner.of(indexEntries).map(Databean::getKey).flush(iks -> ((SortedMapStorage.SortedMapStorageNode)this.indexNode).deleteMulti(iks, config));
    }

    @Override
    public void onPut(D databean, Config config) {
        if (databean == null) {
            throw new IllegalArgumentException("invalid null databean");
        }
        Object sampleIndexEntry = this.createIndexEntry();
        List indexEntries = sampleIndexEntry.createFromDatabean(databean);
        ((SortedMapStorage.SortedMapStorageNode)this.indexNode).putMulti(indexEntries, config);
    }

    @Override
    public void onPutMulti(Collection<D> databeans, Config config) {
        if (databeans == null) {
            return;
        }
        if (databeans.contains(null)) {
            throw new IllegalArgumentException("invalid null databean");
        }
        List<IE> indexEntries = this.getIndexEntriesFromDatabeans(databeans);
        ((SortedMapStorage.SortedMapStorageNode)this.indexNode).putMulti(indexEntries, config);
    }

    private List<IE> getIndexEntriesFromPrimaryKeys(Collection<PK> primaryKeys) {
        ArrayList<IndexEntry> indexEntries = new ArrayList<IndexEntry>(primaryKeys.size());
        for (PrimaryKey key : primaryKeys) {
            Object indexEntryBuilder = this.createIndexEntry();
            if (indexEntryBuilder instanceof UniqueKeyIndexEntry) {
                IndexEntry indexEntry = (IndexEntry)((UniqueKeyIndexEntry)indexEntryBuilder).fromPrimaryKey(key);
                indexEntries.add(indexEntry);
                continue;
            }
            throw new IllegalArgumentException("Unable to find index from PK, please call deleteMultiDatabeans method instead");
        }
        return indexEntries;
    }

    private List<IE> getIndexEntriesFromDatabeans(Collection<D> databeans) {
        Object sampleIndexEntry = this.createIndexEntry();
        ArrayList indexEntries = new ArrayList(databeans.size());
        for (Databean databean : databeans) {
            List indexEntriesFromSingleDatabean = sampleIndexEntry.createFromDatabean(databean);
            if (indexEntriesFromSingleDatabean == null) continue;
            indexEntries.addAll(indexEntriesFromSingleDatabean);
        }
        return indexEntries;
    }
}

